/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.QueryTypeImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;

public class DiscoveryService {

    public static class GetContentChanges
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String changeLogToken = this.getStringParameter(request, "changeLogToken");
            Boolean includeProperties = this.getBooleanParameter(request, "includeProperties");
            String filter = this.getStringParameter(request, "filter");
            Boolean includePolicyIds = this.getBooleanParameter(request, "includePolicyIds");
            Boolean includeAcl = this.getBooleanParameter(request, "includeACL");
            BigInteger maxItems = this.getBigIntegerParameter(request, "maxItems");
            if (this.stopBeforeService(service)) {
                return;
            }
            Holder changeLogTokenHolder = new Holder((Object)changeLogToken);
            ObjectList changes = service.getContentChanges(repositoryId, changeLogTokenHolder, includeProperties, filter, includePolicyIds, includeAcl, maxItems, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (changes == null) {
                throw new CmisRuntimeException("Changes are null!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            GregorianCalendar now = new GregorianCalendar();
            feed.writeFeedElements("contentChanges", null, "", "Content Change", now, null, changes.getNumItems());
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "changes", null);
            selfLink.addParameter("changeLogToken", (Object)changeLogToken);
            selfLink.addParameter("includeProperties", (Object)includeProperties);
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("includePolicyIds", (Object)includePolicyIds);
            selfLink.addParameter("includeACL", (Object)includeAcl);
            selfLink.addParameter("maxItems", (Object)maxItems);
            feed.writeSelfLink(selfLink.toString(), null);
            if (changeLogTokenHolder.getValue() != null) {
                if (Boolean.TRUE.equals(changes.hasMoreItems())) {
                    UrlBuilder nextLink = this.compileUrlBuilder(baseUrl, "changes", null);
                    nextLink.addParameter("changeLogToken", changeLogTokenHolder.getValue());
                    nextLink.addParameter("includeProperties", (Object)includeProperties);
                    nextLink.addParameter("filter", (Object)filter);
                    nextLink.addParameter("includePolicyIds", (Object)includePolicyIds);
                    nextLink.addParameter("includeACL", (Object)includeAcl);
                    nextLink.addParameter("maxItems", (Object)maxItems);
                    feed.writeNextLink(nextLink.toString());
                }
                XMLStreamWriter writer = feed.getWriter();
                writer.writeStartElement("chemistry", "changeLogToken", "http://chemistry.apache.org/");
                writer.writeNamespace("chemistry", "http://chemistry.apache.org/");
                writer.writeCharacters((String)changeLogTokenHolder.getValue());
                writer.writeEndElement();
            }
            if (changes.getObjects() != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                for (ObjectData object : changes.getObjects()) {
                    if (object == null) continue;
                    this.writeContentChangesObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false, context.getCmisVersion());
                }
            }
            feed.writeExtensions((ExtensionsData)changes);
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class Query
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String statement = null;
            Boolean searchAllVersions = null;
            Boolean includeAllowableActions = null;
            IncludeRelationships includeRelationships = null;
            String renditionFilter = null;
            BigInteger maxItems = null;
            BigInteger skipCount = null;
            int statusCode = 0;
            if ("POST".equals(request.getMethod())) {
                QueryTypeImpl queryType = null;
                XMLStreamReader parser = null;
                try {
                    parser = XMLUtils.createParser((InputStream)request.getInputStream());
                    XMLUtils.findNextStartElemenet((XMLStreamReader)parser);
                    queryType = XMLConverter.convertQuery((XMLStreamReader)parser);
                }
                catch (XMLStreamException e) {
                    throw new CmisInvalidArgumentException("Invalid query request!", (Throwable)e);
                }
                finally {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (XMLStreamException e2) {}
                    }
                }
                statement = queryType.getStatement();
                searchAllVersions = queryType.getSearchAllVersions();
                includeAllowableActions = queryType.getIncludeAllowableActions();
                includeRelationships = queryType.getIncludeRelationships();
                renditionFilter = queryType.getRenditionFilter();
                maxItems = queryType.getMaxItems();
                skipCount = queryType.getSkipCount();
                statusCode = 201;
            } else if ("GET".equals(request.getMethod())) {
                statement = this.getStringParameter(request, "q");
                searchAllVersions = this.getBooleanParameter(request, "searchAllVersions");
                includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
                includeRelationships = this.getEnumParameter(request, "includeRelationships", IncludeRelationships.class);
                renditionFilter = this.getStringParameter(request, "renditionFilter");
                maxItems = this.getBigIntegerParameter(request, "maxItems");
                skipCount = this.getBigIntegerParameter(request, "skipCount");
                statusCode = 200;
            } else {
                throw new CmisRuntimeException("Invalid HTTP method!");
            }
            if (this.stopBeforeService(service)) {
                return;
            }
            ObjectList results = service.query(repositoryId, statement, searchAllVersions, includeAllowableActions, includeRelationships, renditionFilter, maxItems, skipCount, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (results == null) {
                throw new CmisRuntimeException("Results are null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            UrlBuilder pagingUrl = this.compileUrlBuilder(baseUrl, "query", null);
            pagingUrl.addParameter("q", (Object)statement);
            pagingUrl.addParameter("searchAllVersions", (Object)searchAllVersions);
            pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            pagingUrl.addParameter("includeRelationships", (Object)includeRelationships);
            UrlBuilder location = new UrlBuilder(pagingUrl);
            location.addParameter("maxItems", (Object)maxItems);
            location.addParameter("skipCount", (Object)skipCount);
            response.setStatus(statusCode);
            response.setContentType("application/atom+xml;type=feed");
            response.setHeader("Location", location.toString());
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            GregorianCalendar now = new GregorianCalendar();
            feed.writeFeedElements("query", null, "", "Query", now, null, results.getNumItems());
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            feed.writePagingLinks(pagingUrl, maxItems, skipCount, results.getNumItems(), results.hasMoreItems(), PAGE_SIZE);
            CmisVersion cmisVersion = context.getCmisVersion();
            if (results.getObjects() != null) {
                AtomEntry entry = new AtomEntry(feed.getWriter());
                int idCounter = 0;
                for (ObjectData result : results.getObjects()) {
                    if (result == null) continue;
                    this.writeQueryResultEntry(entry, result, "id-" + ++idCounter, now, cmisVersion);
                }
            }
            feed.writeExtensions((ExtensionsData)results);
            feed.endFeed();
            feed.endDocument();
        }

        private void writeQueryResultEntry(AtomEntry entry, ObjectData result, String id, GregorianCalendar now, CmisVersion cmisVersion) throws Exception {
            if (result == null) {
                return;
            }
            entry.startEntry(false);
            entry.writeAuthor("");
            entry.writeId(entry.generateAtomId(id));
            entry.writePublished(now);
            entry.writeTitle("Query Result " + id);
            entry.writeUpdated(now);
            XMLConverter.writeObject((XMLStreamWriter)entry.getWriter(), (CmisVersion)cmisVersion, (boolean)false, (String)"object", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (ObjectData)result);
            entry.endEntry();
        }
    }
}

