/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.CollectionsHelper;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntryParser;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public class VersioningService {

    public static class DeleteAllVersions
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            if (this.stopBeforeService(service)) {
                return;
            }
            service.deleteObjectOrCancelCheckOut(repositoryId, objectId, Boolean.TRUE, null);
            if (this.stopAfterService(service)) {
                return;
            }
            response.setStatus(204);
        }
    }

    public static class GetAllVersions
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            String versionSeriesId = this.getStringParameter(request, "versionSeries");
            String filter = this.getStringParameter(request, "filter");
            Boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions");
            if (this.stopBeforeService(service)) {
                return;
            }
            List versions = service.getAllVersions(repositoryId, objectId, versionSeriesId, filter, includeAllowableActions, null);
            if (this.stopAfterService(service)) {
                return;
            }
            if (CollectionsHelper.isNullOrEmpty((Collection)versions)) {
                throw new CmisRuntimeException("Version list is null or empty!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            ObjectInfo latestObjectInfo = service.getObjectInfo(repositoryId, ((ObjectData)versions.get(0)).getId());
            ObjectInfo firstObjectInfo = service.getObjectInfo(repositoryId, ((ObjectData)versions.get(versions.size() - 1)).getId());
            feed.writeFeedElements(versionSeriesId, null, firstObjectInfo.getCreatedBy(), latestObjectInfo.getName(), latestObjectInfo.getLastModificationDate(), null, null);
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            if (objectId != null) {
                feed.writeViaLink(this.compileUrl(baseUrl, "entry", objectId));
            }
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectData object : versions) {
                if (object == null) continue;
                this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false, context.getCmisVersion());
            }
            feed.endFeed();
            feed.endDocument();
        }
    }

    public static class CheckOut
    extends AbstractAtomPubServiceCall {
        @Override
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            ThresholdOutputStreamFactory streamFactory = (ThresholdOutputStreamFactory)context.get("streamFactory");
            AtomEntryParser parser = new AtomEntryParser(streamFactory);
            parser.setIgnoreAtomContentSrc(true);
            parser.parse((InputStream)request.getInputStream());
            if (this.stopBeforeService(service)) {
                return;
            }
            Holder checkOutId = new Holder((Object)parser.getId());
            service.checkOut(repositoryId, checkOutId, null, null);
            if (this.stopAfterService(service)) {
                return;
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, (String)checkOutId.getValue());
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            ObjectData object = objectInfo.getObject();
            if (object == null) {
                throw new CmisRuntimeException("Object is null!");
            }
            if (object.getId() == null) {
                throw new CmisRuntimeException("Object Id is null!");
            }
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            String location = this.compileUrl(baseUrl, "entry", object.getId());
            response.setStatus(201);
            response.setContentType("application/atom+xml;type=entry");
            response.setHeader("Content-Location", location);
            response.setHeader("Location", location);
            AtomEntry entry = new AtomEntry();
            entry.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, true, context.getCmisVersion());
            entry.endDocument();
        }
    }
}

