/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.browser;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.chemistry.opencmis.server.impl.browser.MultipartParser;
import org.apache.chemistry.opencmis.server.shared.HttpUtils;
import org.apache.chemistry.opencmis.server.shared.QueryStringHttpServletRequestWrapper;
import org.apache.chemistry.opencmis.server.shared.ThresholdOutputStreamFactory;

public final class POSTHttpServletRequestWrapper
extends QueryStringHttpServletRequestWrapper {
    private String filename;
    private String contentType;
    private BigInteger size;
    private InputStream stream;

    public POSTHttpServletRequestWrapper(HttpServletRequest request, ThresholdOutputStreamFactory streamFactory) throws IOException {
        super(request);
        boolean isMultipart = MultipartParser.isMultipartContent(request);
        if (isMultipart) {
            String contentTypeControl;
            MultipartParser parser = new MultipartParser(request, streamFactory);
            parser.parse();
            if (parser.hasContent()) {
                this.filename = parser.getFilename();
                this.contentType = parser.getContentType();
                this.size = parser.getSize();
                this.stream = parser.getStream();
            }
            for (Map.Entry<String, String[]> e : parser.getFields().entrySet()) {
                this.addParameter(e.getKey(), e.getValue());
            }
            String filenameControl = HttpUtils.getStringParameter((HttpServletRequest)this, "filename");
            if (filenameControl != null && filenameControl.trim().length() > 0) {
                this.filename = filenameControl;
            }
            if ((contentTypeControl = HttpUtils.getStringParameter((HttpServletRequest)this, "contenttype")) != null && contentTypeControl.trim().length() > 0) {
                this.contentType = contentTypeControl;
            }
        } else {
            StringBuilder sb = new StringBuilder();
            InputStreamReader sr = new InputStreamReader((InputStream)request.getInputStream(), "UTF-8");
            char[] buffer = new char[4096];
            int c = 0;
            while ((c = sr.read(buffer)) > -1) {
                sb.append(buffer, 0, c);
            }
            if (sb.length() < 3) {
                Map parameterMap = request.getParameterMap();
                this.getParameterMap().putAll(parameterMap);
            } else {
                this.parseFormData(sb.toString());
            }
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public InputStream getStream() {
        return this.stream;
    }
}

