/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.executors;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.EnvironmentDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.executors.AbstractExecutor;
import org.nuxeo.log4j.ThreadedStreamGobbler;

public class ShellExecutor
extends AbstractExecutor {
    private static final Log log = LogFactory.getLog(ShellExecutor.class);

    @Override
    @Deprecated
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params) {
        return this.exec(cmdDesc, params, new EnvironmentDescriptor());
    }

    @Override
    public ExecResult exec(CommandLineDescriptor cmdDesc, CmdParameters params, EnvironmentDescriptor env) {
        ThreadedStreamGobbler err;
        ThreadedStreamGobbler out;
        Process p1;
        Object[] cmd;
        long t0 = System.currentTimeMillis();
        List<String> output = Collections.synchronizedList(new ArrayList());
        try {
            if (SystemUtils.IS_OS_WINDOWS) {
                Object[] paramsArray = ShellExecutor.getParametersArray(cmdDesc, params);
                cmd = new String[]{"cmd", "/C", cmdDesc.getCommand()};
                cmd = (String[])ArrayUtils.addAll((Object[])cmd, (Object[])paramsArray);
            } else {
                String paramsString = ShellExecutor.getParametersString(cmdDesc, params);
                cmd = new String[]{"/bin/sh", "-c", cmdDesc.getCommand() + " " + paramsString};
            }
        }
        catch (IllegalArgumentException e) {
            return new ExecResult(cmdDesc.getCommand(), e);
        }
        String commandLine = StringUtils.join((Object[])cmd, (String)" ");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Running system command: " + commandLine));
            }
            ProcessBuilder processBuilder = new ProcessBuilder((String[])cmd).directory(new File(env.getWorkingDirectory()));
            processBuilder.environment().putAll(env.getParameters());
            p1 = processBuilder.start();
        }
        catch (IOException e) {
            return new ExecResult(commandLine, e);
        }
        if (cmdDesc.getReadOutput()) {
            out = new ThreadedStreamGobbler(p1.getInputStream(), output);
            err = new ThreadedStreamGobbler(p1.getErrorStream(), output);
        } else {
            out = new ThreadedStreamGobbler(p1.getInputStream(), 2);
            err = new ThreadedStreamGobbler(p1.getErrorStream(), 5);
        }
        err.start();
        out.start();
        int exitCode = 0;
        try {
            exitCode = p1.waitFor();
            out.join();
            err.join();
        }
        catch (InterruptedException e) {
            return new ExecResult(commandLine, e);
        }
        long t1 = System.currentTimeMillis();
        return new ExecResult(commandLine, output, t1 - t0, exitCode);
    }
}

