/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.multi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.multi.MultiDirectory;
import org.nuxeo.ecm.directory.multi.MultiDirectoryDescriptor;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;

public class MultiDirectoryRegistry
extends ContributionFragmentRegistry<MultiDirectoryDescriptor> {
    private static final Log log = LogFactory.getLog(MultiDirectoryRegistry.class);
    protected Map<String, MultiDirectoryDescriptor> descriptors = new HashMap<String, MultiDirectoryDescriptor>();
    protected Map<String, MultiDirectory> directories = new HashMap<String, MultiDirectory>();

    public String getContributionId(MultiDirectoryDescriptor contrib) {
        return contrib.name;
    }

    public void contributionUpdated(String id, MultiDirectoryDescriptor descriptor, MultiDirectoryDescriptor newOrigContrib) {
        String name = descriptor.name;
        if (descriptor.remove) {
            this.contributionRemoved(id, descriptor);
        } else {
            if (this.descriptors.containsKey(name)) {
                log.info((Object)("Directory registration updated: " + name));
            } else {
                log.info((Object)("Directory registered: " + name));
            }
            this.descriptors.put(id, descriptor);
            MultiDirectory directory = new MultiDirectory(descriptor);
            this.directories.put(name, directory);
        }
    }

    public void contributionRemoved(String id, MultiDirectoryDescriptor origContrib) {
        this.descriptors.remove(id);
        Directory dir = (Directory)this.directories.remove(id);
        if (dir != null) {
            try {
                dir.shutdown();
            }
            catch (DirectoryException e) {
                log.error((Object)String.format("Error while shutting down directory '%s'", id), (Throwable)e);
            }
        }
        log.info((Object)("Directory removed: " + id));
    }

    public MultiDirectoryDescriptor clone(MultiDirectoryDescriptor orig) {
        return orig.clone();
    }

    public void merge(MultiDirectoryDescriptor src, MultiDirectoryDescriptor dst) {
        boolean remove = src.remove;
        boolean wasRemoved = dst.remove;
        if (remove) {
            dst.remove = remove;
            return;
        }
        dst.merge(src, wasRemoved);
    }

    public MultiDirectory getDirectory(String name) {
        return this.directories.get(name);
    }

    public List<Directory> getDirectories() {
        ArrayList<Directory> res = new ArrayList<Directory>();
        res.addAll(this.directories.values());
        return res;
    }
}

