/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.formats;

import org.nuxeo.theme.Manager;
import org.nuxeo.theme.formats.Format;
import org.nuxeo.theme.formats.FormatType;
import org.nuxeo.theme.themes.ThemeException;
import org.nuxeo.theme.types.TypeFamily;
import org.nuxeo.theme.uids.UidManager;

public final class FormatFactory {
    private FormatFactory() {
    }

    public static Format create(String typeName) throws ThemeException {
        Format format = null;
        FormatType formatType = (FormatType)Manager.getTypeRegistry().lookup(TypeFamily.FORMAT, typeName);
        if (formatType == null) {
            throw new ThemeException("Unknown format type: " + typeName);
        }
        UidManager uidManager = Manager.getUidManager();
        try {
            format = (Format)Class.forName(formatType.getFormatClass()).newInstance();
        }
        catch (InstantiationException e) {
            throw new ThemeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ThemeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ThemeException("Format creation failed: " + typeName, e);
        }
        format.setFormatType(formatType);
        uidManager.register(format);
        return format;
    }
}

