/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.rmi.dgc.VMID;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;

public class EventBundleImpl
implements EventBundle {
    private static final long serialVersionUID = 1L;
    protected VMID vmid;
    protected final List<Event> events = new ArrayList<Event>();
    protected final Set<String> eventNames = new HashSet<String>();

    public EventBundleImpl(VMID sourceVMID) {
        this.vmid = sourceVMID;
    }

    public EventBundleImpl() {
        this(EventServiceImpl.VMID);
    }

    @Override
    public boolean hasRemoteSource() {
        return !this.vmid.equals(EventServiceImpl.VMID);
    }

    @Override
    public String getName() {
        if (this.events.isEmpty()) {
            return null;
        }
        return this.events.get(0).getContext().getRepositoryName();
    }

    @Override
    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    @Override
    public Event peek() {
        return this.events.get(0);
    }

    @Override
    public void push(Event event) {
        this.events.add(event);
        String eventName = event.getName();
        if (eventName != null) {
            this.eventNames.add(eventName);
        }
    }

    @Override
    public int size() {
        return this.events.size();
    }

    @Override
    public Iterator<Event> iterator() {
        return this.events.iterator();
    }

    @Override
    public VMID getSourceVMID() {
        return this.vmid;
    }

    @Override
    public boolean containsEventName(String eventName) {
        if (eventName == null) {
            return false;
        }
        return this.eventNames.contains(eventName);
    }
}

