/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.IOException;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.ecm.core.scheduler.SchedulerServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.quartz.SchedulerException;

public class ReloadListener
implements EventListener {
    public boolean aboutToHandleEvent(Event event) {
        return true;
    }

    public void handleEvent(Event event) {
        if (event.getId() == "before-reload") {
            SchedulerServiceImpl scheduler = this.lookup();
            if (scheduler == null) {
                return;
            }
            scheduler.shutdownScheduler();
        } else if (event.getId() == "after-reload") {
            SchedulerServiceImpl scheduler = this.lookup();
            if (scheduler == null) {
                return;
            }
            try {
                scheduler.setupScheduler();
            }
            catch (IOException | SchedulerException cause) {
                LogFactory.getLog(ReloadListener.class).error((Object)"Cannot reload scheduler", cause);
            }
        }
    }

    SchedulerServiceImpl lookup() {
        SchedulerService scheduler = (SchedulerService)Framework.getService(SchedulerService.class);
        if (scheduler instanceof SchedulerServiceImpl) {
            return (SchedulerServiceImpl)scheduler;
        }
        return null;
    }
}

