/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.customize.ui;

import fr.toutatice.ecm.platform.service.customize.ui.CategoryDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.CustomizeUIService;
import fr.toutatice.ecm.platform.service.customize.ui.LayoutDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.LayoutsDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.TemplateDescriptor;
import fr.toutatice.ecm.platform.service.customize.ui.ToutaticeMockFacesContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.faces.context.FacesContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewLayout;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRowDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.LayoutRowDefinitionImpl;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetReferenceImpl;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CustomizeUIServiceImpl
extends DefaultComponent
implements CustomizeUIService {
    private static final long serialVersionUID = 6462426331447513648L;
    private static final Log log = LogFactory.getLog(CustomizeUIServiceImpl.class);
    private static final String QUERY_WITH_NO_PROXY = "AND ((ecm:name NOT LIKE '%.proxy') OR (ecm:name LIKE '%.remote.proxy'))";
    private static final String CONTENT_CATEGORY = "content";
    private static final String PORTAL_LAYOUT = "cv_ContentOrderedReadNWrite@cvListingLayout";
    private static final String LAYOUTS_PT_EXT = "layouts";
    private static final String CATEGORIES_PT_EXT = "categories";
    private TypeManager typeManager;
    private ContentViewService contentViewService;
    private WebLayoutManager webLayoutManager;
    private SchemaManager schemaManager;
    private Collection<Type> allowedTypesUnderPublishSpace;
    private static List<String> modifiedContentViewsLayouts = new ArrayList<String>();
    private List<LayoutsDescriptor> allLayoutsDescriptor;
    private List<String> categories;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.typeManager = (TypeManager)Framework.getService(TypeManager.class);
        this.contentViewService = (ContentViewService)Framework.getService(ContentViewService.class);
        this.webLayoutManager = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        this.schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        this.allLayoutsDescriptor = new ArrayList<LayoutsDescriptor>();
        this.categories = new ArrayList<String>();
        this.categories.add(CONTENT_CATEGORY);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (LAYOUTS_PT_EXT.equals(extensionPoint)) {
            LayoutsDescriptor layoutsDescriptor = (LayoutsDescriptor)contribution;
            this.allLayoutsDescriptor.add(layoutsDescriptor);
        } else if (CATEGORIES_PT_EXT.equals(extensionPoint)) {
            CategoryDescriptor categoryDescriptor = (CategoryDescriptor)contribution;
            this.categories.add(categoryDescriptor.getCategory());
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        Set publishSpaces = this.schemaManager.getDocumentTypeNamesForFacet("TTCPublishSpace");
        for (String publishSpace : publishSpaces) {
            Type psType = this.typeManager.getType(publishSpace);
            this.allowedTypesUnderPublishSpace = this.getAllowedTypesUnderPublishSpace(new ArrayList<Type>(), psType);
            this.adaptContentViews();
            for (LayoutsDescriptor layoutsDescriptor : this.allLayoutsDescriptor) {
                this.overrideLayoutsTemplate(layoutsDescriptor);
            }
        }
    }

    @Override
    public void adaptContentViews() throws Exception {
        if (this.allowedTypesUnderPublishSpace != null) {
            Collection types = this.typeManager.getTypes();
            for (Type type : types) {
                if (this.allowedTypesUnderPublishSpace.contains(type)) {
                    this.addPublishWidgetToResultLayout(type);
                }
                this.setNoProxyQueryToContentViews(type);
            }
        }
    }

    @Override
    public void overrideLayoutsTemplate(LayoutsDescriptor layoutsDescriptor) {
        Object[] layoutsToOverride = layoutsDescriptor.getLayouts();
        if (ArrayUtils.isNotEmpty((Object[])layoutsToOverride)) {
            for (Object layoutToOverride : layoutsToOverride) {
                TemplateDescriptor[] templatesDescriptor;
                String layoutNameToOverride = ((LayoutDescriptor)layoutToOverride).getName();
                for (TemplateDescriptor templateDescriptor : templatesDescriptor = ((LayoutDescriptor)layoutToOverride).getTemplates()) {
                    String overrideTemplateName = templateDescriptor.getName();
                    String mode = templateDescriptor.getMode();
                    LayoutDefinition layoutToOverrideDef = this.webLayoutManager.getLayoutDefinition(layoutNameToOverride);
                    Map templatesByMode = layoutToOverrideDef.getTemplates();
                    templatesByMode.put(mode, overrideTemplateName);
                    layoutToOverrideDef.setTemplates(templatesByMode);
                }
            }
        }
    }

    private void addPublishWidgetToResultLayout(Type type) throws Exception {
        for (String cvCategory : this.categories) {
            Object[] typeContentViewNames = type.getContentViews(cvCategory);
            if (!ArrayUtils.isNotEmpty((Object[])typeContentViewNames)) continue;
            for (Object typeContentViewName : typeContentViewNames) {
                ContentView contentView = this.contentViewService.getContentView((String)typeContentViewName);
                if (contentView != null) {
                    List resultLayouts = contentView.getResultLayouts();
                    for (ContentViewLayout resultLayout : resultLayouts) {
                        LayoutRowDefinition[] rows;
                        String layoutName = resultLayout.getName();
                        if (modifiedContentViewsLayouts.contains(layoutName) || PORTAL_LAYOUT.equals(layoutName)) continue;
                        modifiedContentViewsLayouts.add(layoutName);
                        LayoutDefinition layoutDefinition = this.webLayoutManager.getLayoutDefinition(layoutName);
                        if (!this.widgetNotYetPresent(layoutDefinition, rows = layoutDefinition.getRows())) continue;
                        ArrayList<WidgetReferenceImpl> widgets = new ArrayList<WidgetReferenceImpl>(1);
                        WidgetReferenceImpl widgetRef = new WidgetReferenceImpl("publishing_status");
                        widgets.add(widgetRef);
                        HashMap properties = new HashMap();
                        HashMap<String, Object> property = new HashMap<String, Object>();
                        property.put("useFirstWidgetLabelAsColumnHeader", true);
                        property.put("columnStyleClass", "iconColumn");
                        properties.put("any", property);
                        LayoutRowDefinitionImpl layoutRowDefinitionImpl = new LayoutRowDefinitionImpl("publishing_status", properties, widgets, true, true);
                        LayoutRowDefinition[] modifiedRows = Arrays.copyOf(rows, rows.length + 1);
                        modifiedRows[rows.length] = layoutRowDefinitionImpl;
                        layoutDefinition.setRows(modifiedRows);
                    }
                    continue;
                }
                log.error((Object)((String)typeContentViewName + " not defined for type " + type.getLabel()));
            }
        }
    }

    private boolean widgetNotYetPresent(LayoutDefinition layoutDefinition, LayoutRowDefinition[] rows) {
        boolean added = false;
        if (ArrayUtils.isNotEmpty((Object[])rows)) {
            List<LayoutRowDefinition> rowsList = Arrays.asList(rows);
            Iterator<LayoutRowDefinition> iterator = rowsList.iterator();
            while (iterator.hasNext() && !added) {
                Serializable template;
                Object widgetReference;
                WidgetDefinition widgetDefinition;
                Object[] widgetReferences;
                LayoutRowDefinition row = iterator.next();
                if ("publishing_status".equals(row.getName())) {
                    added = true;
                }
                if (added || !ArrayUtils.isNotEmpty((Object[])(widgetReferences = row.getWidgetReferences())) || (widgetDefinition = layoutDefinition.getWidgetDefinition((widgetReference = widgetReferences[0]).getName())) == null) continue;
                Map properties = widgetDefinition.getProperties();
                Map anyProperties = (Map)properties.get("any");
                Map viewProperties = (Map)properties.get("view");
                HashMap wgtProperties = new HashMap();
                if (viewProperties != null) {
                    wgtProperties.putAll(viewProperties);
                }
                if (anyProperties != null) {
                    wgtProperties.putAll(anyProperties);
                }
                if ((template = (Serializable)wgtProperties.get("template")) == null) continue;
                String tmpl = (String)((Object)template);
                added = StringUtils.equals((String)tmpl, (String)"/widgets/toutatice_widget_document_listing_icon.xhtml");
            }
        }
        return !added;
    }

    private void setNoProxyQueryToContentViews(Type type) throws Exception {
        ToutaticeMockFacesContext mockFacesContext = new ToutaticeMockFacesContext(){

            @Override
            public Object evaluateExpressionGet(FacesContext context, String expression, Class expectedType) throws ELException {
                if (expression.startsWith("#{")) {
                    return "";
                }
                return null;
            }
        };
        mockFacesContext.setCurrent();
        for (String cvCategory : this.categories) {
            Object[] typeContentViewNames = type.getContentViews(cvCategory);
            if (!ArrayUtils.isNotEmpty((Object[])typeContentViewNames)) continue;
            for (Object typeContentViewName : typeContentViewNames) {
                ContentView contentView = this.contentViewService.getContentView((String)typeContentViewName);
                if (contentView == null) continue;
                PageProvider pageProvider = contentView.getPageProvider(null, new ArrayList(), null, null, new Object[0]);
                PageProviderDefinition pageProviderDefinition = pageProvider.getDefinition();
                String pattern = pageProviderDefinition.getPattern();
                if (pattern != null) {
                    pattern = pattern + QUERY_WITH_NO_PROXY;
                    pageProviderDefinition.setPattern(pattern);
                } else {
                    WhereClauseDefinition whereClause = pageProviderDefinition.getWhereClause();
                    if (whereClause != null) {
                        String query = whereClause.getFixedPart();
                        query = query + QUERY_WITH_NO_PROXY;
                        whereClause.setFixedPart(query);
                    }
                }
                pageProviderDefinition.setEnabled(true);
            }
        }
        mockFacesContext.relieveCurrent();
    }

    private Collection<Type> getAllowedTypesUnderPublishSpace(Collection<Type> allowedSubTypesUnderPublishSpace, Type type) {
        Collection allowedSubTypes = this.typeManager.getAllowedSubTypes(type.getId());
        if (CollectionUtils.isNotEmpty((Collection)allowedSubTypes)) {
            for (Type allowedType : allowedSubTypes) {
                if (allowedSubTypesUnderPublishSpace.contains(allowedType)) continue;
                allowedSubTypesUnderPublishSpace.add(allowedType);
                this.getAllowedTypesUnderPublishSpace(allowedSubTypesUnderPublishSpace, allowedType);
            }
        }
        return allowedSubTypesUnderPublishSpace;
    }
}

