/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;

public class ToutaticeDocumentLocation
extends DocumentLocationImpl {
    private static final long serialVersionUID = -1632965927936780332L;
    private static final Log log = LogFactory.getLog(ToutaticeDocumentLocation.class);
    private String serverName;
    private WebIdRef webIdRef;
    private Map<String, String> parameters;

    public String getServerName() {
        return this.serverName;
    }

    public WebIdRef getWebIdRef() {
        return this.webIdRef;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ToutaticeDocumentLocation(String serverName, WebIdRef docRef) {
        super(serverName, (DocumentRef)docRef);
        this.serverName = serverName;
        this.webIdRef = docRef;
    }

    public ToutaticeDocumentLocation(DocumentModel doc) {
        super(doc);
        try {
            String webId = (String)((Object)doc.getPropertyValue("ttc:webid"));
            String explicitUrl = (String)((Object)doc.getPropertyValue("ttc:explicitUrl"));
            String extensionUrl = (String)((Object)doc.getPropertyValue("ttc:extensionUrl"));
            this.webIdRef = new WebIdRef(explicitUrl, webId, extensionUrl);
            this.setLocationParameters(doc);
        }
        catch (Exception e) {
            log.error((Object)("Can not get webId property: " + e.getMessage()));
        }
    }

    protected void setLocationParameters(DocumentModel doc) {
        DocumentModelList parentList;
        this.parameters = new HashMap<String, String>(0);
        if (doc.isProxy() && ToutaticeDocumentHelper.isInPublishSpace((CoreSession)doc.getCoreSession(), (DocumentModel)doc) && ToutaticeDocumentHelper.isRemoteProxy((DocumentModel)doc) && CollectionUtils.isNotEmpty((Collection)(parentList = ToutaticeDocumentHelper.getParentList((CoreSession)doc.getCoreSession(), (DocumentModel)doc, null, (boolean)true, (boolean)true)))) {
            DocumentModel firstParent = (DocumentModel)parentList.get(0);
            String parentWebId = (String)((Object)firstParent.getPropertyValue("ttc:webid"));
            if (StringUtils.isNotEmpty((String)parentWebId)) {
                this.parameters.put("parentId", parentWebId);
            } else {
                this.parameters.put("parentPath", firstParent.getPathAsString());
            }
        }
    }
}

