/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.nuxeo.ecm.core.api.model.Delta;

public class State
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int HASHMAP_DEFAULT_INITIAL_CAPACITY = 16;
    private static final float HASHMAP_DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEBUG_MAX_STRING = 100;
    private static final int DEBUG_MAX_ARRAY = 10;
    public static final State EMPTY = new State(Collections.emptyMap());
    private static final Set<String> TO_STRING_KEY_ORDER = new LinkedHashSet<String>(Arrays.asList("ecm:id", "ecm:primaryType", "ecm:name", "ecm:parentId", "ecm:isVersion", "ecm:isProxy"));
    public static final Nop NOP = Nop.NOP;
    protected final Map<String, Serializable> map;

    private State(Map<String, Serializable> map) {
        this.map = map;
    }

    public State() {
        this(0, false);
    }

    public State(boolean threadSafe) {
        this(0, threadSafe);
    }

    public State(int size) {
        this(size, false);
    }

    public State(int size, boolean threadSafe) {
        int initialCapacity = Math.max((int)((float)size / 0.75f) + 1, 16);
        float loadFactor = 0.75f;
        this.map = threadSafe ? new ConcurrentHashMap<String, Serializable>(initialCapacity, loadFactor) : new HashMap<String, Serializable>(initialCapacity, loadFactor);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Serializable get(Object key) {
        return this.map.get(key);
    }

    public void putInternal(String key, Serializable value) {
        if (value == null) {
            this.map.remove(key);
        } else {
            this.map.put(key, value);
        }
    }

    public void put(String key, Serializable value) {
        Serializable oldValue = this.map.get(key);
        if (oldValue instanceof Delta) {
            Delta oldDelta = (Delta)oldValue;
            if (value instanceof Delta) {
                if (value != oldDelta) {
                    value = oldDelta.add((Delta)value);
                }
            } else if (oldDelta.getFullValue().equals(value)) {
                return;
            }
        }
        this.putInternal(key, value);
    }

    public Serializable remove(Object key) {
        return this.map.remove(key);
    }

    public Set<String> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public Set<Map.Entry<String, Serializable>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        boolean empty = true;
        for (String key : TO_STRING_KEY_ORDER) {
            if (!this.containsKey(key)) continue;
            if (!empty) {
                buf.append(", ");
            }
            empty = false;
            buf.append(key);
            buf.append('=');
            State.toString(buf, this.get(key));
        }
        Object[] keys = this.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            if (TO_STRING_KEY_ORDER.contains(key)) continue;
            if (!empty) {
                buf.append(", ");
            }
            empty = false;
            buf.append((String)key);
            buf.append('=');
            State.toString(buf, this.get(key));
        }
        buf.append('}');
        return buf.toString();
    }

    protected static void toString(StringBuilder buf, Object value) {
        if (value instanceof String) {
            String v = (String)value;
            if (v.length() > 100) {
                v = v.substring(0, 100) + "...(" + v.length() + " chars)...";
            }
            buf.append(v);
        } else if (value instanceof Calendar) {
            char sign;
            Calendar cal = (Calendar)value;
            int offset = cal.getTimeZone().getOffset(cal.getTimeInMillis()) / 60000;
            if (offset < 0) {
                offset = -offset;
                sign = '-';
            } else {
                sign = '+';
            }
            buf.append(String.format("Calendar(%04d-%02d-%02dT%02d:%02d:%02d.%03d%c%02d:%02d)", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), cal.get(14), Character.valueOf(sign), offset / 60, offset % 60));
        } else if (value instanceof Object[]) {
            Object[] v = (Object[])value;
            buf.append('[');
            for (int i = 0; i < v.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                    if (i > 10) {
                        buf.append("...(" + v.length + " items)...");
                        break;
                    }
                }
                State.toString(buf, v[i]);
            }
            buf.append(']');
        } else {
            buf.append(value);
        }
    }

    public static class ListDiff
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public boolean isArray;
        public List<Object> diff;
        public List<Object> rpush;

        public String toString() {
            return this.getClass().getSimpleName() + '(' + (this.isArray ? "array" : "list") + (this.diff == null ? "" : ", DIFF " + this.diff) + (this.rpush == null ? "" : ", RPUSH " + this.rpush) + ')';
        }
    }

    private static enum Nop {
        NOP;

    }

    public static class StateDiff
    extends State {
        private static final long serialVersionUID = 1L;

        @Override
        public void put(String key, Serializable value) {
            this.map.put(key, value);
        }
    }
}

