/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.lock;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.lock.LockManager;
import org.nuxeo.ecm.core.storage.lock.LockManagerDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class LockManagerService
extends DefaultComponent {
    private static final Log log = LogFactory.getLog(LockManagerService.class);
    private static final String XP_LOCKMANAGER = "lockmanager";
    protected LockManagerDescriptorRegistry registry = new LockManagerDescriptorRegistry();
    protected Map<String, LockManager> lockManagers = new ConcurrentHashMap<String, LockManager>();

    public void activate(ComponentContext context) throws Exception {
        this.registry.clear();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.registry.clear();
    }

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_LOCKMANAGER.equals(xpoint)) {
            throw new NuxeoException("Unknown extension point: " + xpoint);
        }
        this.addContribution((LockManagerDescriptor)contrib);
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) throws Exception {
        if (!XP_LOCKMANAGER.equals(xpoint)) {
            throw new NuxeoException("Unknown extension point: " + xpoint);
        }
        this.removeContribution((LockManagerDescriptor)contrib);
    }

    protected void addContribution(LockManagerDescriptor descriptor) {
        log.info((Object)("Registered " + descriptor));
        this.registry.addContribution(descriptor);
    }

    protected void removeContribution(LockManagerDescriptor descriptor) {
        log.info((Object)("Unregistered " + descriptor));
        this.registry.removeContribution(descriptor);
    }

    public synchronized LockManager getLockManager(String name) {
        LockManager lockManager = this.lockManagers.get(name);
        if (lockManager == null) {
            LockManagerDescriptor descriptor = this.registry.getLockManagerDescriptor(name);
            if (descriptor == null) {
                return null;
            }
            try {
                Constructor<? extends LockManager> ctor = descriptor.klass.getConstructor(String.class);
                lockManager = ctor.newInstance(name);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new NuxeoException((Throwable)e);
            }
            this.registerLockManager(name, lockManager);
        }
        return lockManager;
    }

    public void registerLockManager(String name, LockManager lockManager) {
        this.lockManagers.put(name, lockManager);
    }

    protected static class LockManagerDescriptorRegistry
    extends SimpleContributionRegistry<LockManagerDescriptor> {
        protected LockManagerDescriptorRegistry() {
        }

        public String getContributionId(LockManagerDescriptor contrib) {
            return contrib.name;
        }

        public LockManagerDescriptor clone(LockManagerDescriptor orig) {
            return new LockManagerDescriptor(orig);
        }

        public void merge(LockManagerDescriptor src, LockManagerDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public LockManagerDescriptor getLockManagerDescriptor(String id) {
            return (LockManagerDescriptor)this.getCurrentContribution(id);
        }
    }
}

