/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitNotFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitNotFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitNotFilterAction() {
        super("Initialize NOT filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        LdapMessage ldapMessage = ldapMessageContainer.getLdapMessage();
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        if (tlv.getLength() == 0) {
            log.error("The Not filter PDU must not be empty");
            throw new DecoderException("The Not filter PDU must not be empty");
        }
        SearchRequest searchRequest = ldapMessage.getSearchRequest();
        NotFilter notFilter = new NotFilter(ldapMessageContainer.getTlvId());
        searchRequest.addCurrentFilter(notFilter);
        if (IS_DEBUG) {
            log.debug("Initialize NOT filter");
        }
    }
}

