/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.filter.LeafNode;

public class SimpleNode
extends LeafNode {
    private Object value;

    public SimpleNode(String attribute, byte[] value, AssertionEnum type) {
        super(attribute, type);
        this.value = value;
        switch (type) {
            case APPROXIMATE: 
            case EQUALITY: 
            case GREATEREQ: 
            case LESSEQ: {
                break;
            }
            case EXTENSIBLE: {
                throw new IllegalArgumentException("Assertion type supplied is extensible.  Use ExtensibleNode instead.");
            }
            case PRESENCE: {
                throw new IllegalArgumentException("Assertion type supplied is presence.  Use PresenceNode instead.");
            }
            case SUBSTRING: {
                throw new IllegalArgumentException("Assertion type supplied is substring.  Use SubstringNode instead.");
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
    }

    public SimpleNode(String attribute, String value, AssertionEnum type) {
        super(attribute, type);
        this.value = value;
        switch (type) {
            case APPROXIMATE: 
            case EQUALITY: 
            case GREATEREQ: 
            case LESSEQ: {
                break;
            }
            case EXTENSIBLE: {
                throw new IllegalArgumentException("Assertion type supplied is extensible.  Use ExtensibleNode instead.");
            }
            case PRESENCE: {
                throw new IllegalArgumentException("Assertion type supplied is presence.  Use PresenceNode instead.");
            }
            case SUBSTRING: {
                throw new IllegalArgumentException("Assertion type supplied is substring.  Use SubstringNode instead.");
            }
            default: {
                throw new IllegalArgumentException("Attribute value assertion type is undefined.");
            }
        }
    }

    public final Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public StringBuffer printToBuffer(StringBuffer buf) {
        buf.append('(').append(this.getAttribute());
        switch (this.getAssertionType()) {
            case APPROXIMATE: {
                buf.append("~=");
                break;
            }
            case EQUALITY: {
                buf.append("=");
                break;
            }
            case GREATEREQ: {
                buf.append(">=");
                break;
            }
            case LESSEQ: {
                buf.append("<=");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        buf.append(this.value);
        buf.append(')');
        if (null != this.getAnnotations() && this.getAnnotations().containsKey("count")) {
            buf.append('[');
            buf.append(this.getAnnotations().get("count").toString());
            buf.append("] ");
        } else {
            buf.append(' ');
        }
        return buf;
    }

    public StringBuffer printRefinementToBuffer(StringBuffer buf) throws UnsupportedOperationException {
        switch (this.getAssertionType()) {
            case EQUALITY: {
                break;
            }
            case APPROXIMATE: {
                throw new UnsupportedOperationException("Approximate assertion isn't valid for a refinement");
            }
            case GREATEREQ: {
                throw new UnsupportedOperationException("GreaterOrEqual assertion isn't valid for a refinement");
            }
            case LESSEQ: {
                throw new UnsupportedOperationException("LessOrEqual assertion isn't valid for a refinement");
            }
            default: {
                throw new UnsupportedOperationException("Undefined assertion for a refinement");
            }
        }
        if (this.getAttribute() == null || !"objectClass".equalsIgnoreCase(this.getAttribute())) {
            throw new UnsupportedOperationException("Invalid attribute " + this.getAttribute() + " for a refinement");
        }
        buf.append("item");
        buf.append(':');
        buf.append(' ');
        buf.append(this.getValue());
        return buf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        this.printToBuffer(buf);
        return buf.toString();
    }

    public void accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            visitor.visit(this);
        }
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof SimpleNode)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return this.value.equals(((SimpleNode)other).getValue());
    }
}

