/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.ObjectClass;
import org.apache.directory.shared.ldap.schema.ObjectClassTypeEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectClass
extends AbstractSchemaObject
implements ObjectClass,
Serializable {
    static final long serialVersionUID = -4744807759763092241L;
    private static final ObjectClass[] EMPTY_OCLASS_ARR = new ObjectClass[0];
    private static final AttributeType[] EMPTY_ATYPE_ARR = new AttributeType[0];
    private ObjectClassTypeEnum type = ObjectClassTypeEnum.ABSTRACT;
    private ArrayList<AttributeType> mayList;
    private ArrayList<AttributeType> mustList;
    private ArrayList<ObjectClass> superClasses;

    DefaultObjectClass(String oid) {
        super(oid);
    }

    @Override
    public ObjectClass[] getSuperClasses() {
        if (this.superClasses == null) {
            return EMPTY_OCLASS_ARR;
        }
        return this.superClasses.toArray(EMPTY_OCLASS_ARR);
    }

    @Override
    public ObjectClassTypeEnum getType() {
        return this.type;
    }

    @Override
    public AttributeType[] getMustList() {
        if (this.mustList == null) {
            return EMPTY_ATYPE_ARR;
        }
        return this.mustList.toArray(EMPTY_ATYPE_ARR);
    }

    @Override
    public boolean isStructural() {
        return this.type == ObjectClassTypeEnum.STRUCTURAL;
    }

    @Override
    public boolean isAbstract() {
        return this.type == ObjectClassTypeEnum.ABSTRACT;
    }

    @Override
    public boolean isAuxiliary() {
        return this.type == ObjectClassTypeEnum.AUXILIARY;
    }

    @Override
    public AttributeType[] getMayList() {
        if (this.mayList == null) {
            return EMPTY_ATYPE_ARR;
        }
        return this.mayList.toArray(EMPTY_ATYPE_ARR);
    }

    void addToMayList(List<AttributeType> mayList) {
        if (this.mayList == null) {
            this.mayList = new ArrayList();
        }
        this.mayList.addAll(mayList);
    }

    void addToMustList(List<AttributeType> mustList) {
        if (this.mustList == null) {
            this.mustList = new ArrayList();
        }
        this.mustList.addAll(mustList);
    }

    void addSuperClasses(List<ObjectClass> superClasses) {
        if (this.superClasses == null) {
            this.superClasses = new ArrayList();
        }
        this.superClasses.addAll(superClasses);
    }

    void setType(ObjectClassTypeEnum type) {
        this.type = type;
    }
}

