/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.components;

import javax.security.auth.kerberos.KerberosPrincipal;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationData;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptionKey;
import org.apache.directory.server.kerberos.shared.messages.value.HostAddresses;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosTime;
import org.apache.directory.server.kerberos.shared.messages.value.TicketFlags;
import org.apache.directory.server.kerberos.shared.messages.value.TransitedEncoding;

public class EncTicketPart
implements Encodable {
    private TicketFlags flags;
    private EncryptionKey sessionKey;
    private KerberosPrincipal clientPrincipal;
    private TransitedEncoding transitedEncoding;
    private KerberosTime authtime;
    private KerberosTime startTime;
    private KerberosTime endTime;
    private KerberosTime renewTill;
    private HostAddresses clientAddresses;
    private AuthorizationData authorizationData;

    public EncTicketPart(TicketFlags flags, EncryptionKey key, KerberosPrincipal clientPrincipal, TransitedEncoding transited, KerberosTime authtime, KerberosTime starttime, KerberosTime endtime, KerberosTime renewTill, HostAddresses caddr, AuthorizationData authorizationData) {
        this.flags = flags;
        this.sessionKey = key;
        this.clientPrincipal = clientPrincipal;
        this.transitedEncoding = transited;
        this.authtime = authtime;
        this.startTime = starttime;
        this.endTime = endtime;
        this.renewTill = renewTill;
        this.clientAddresses = caddr;
        this.authorizationData = authorizationData;
    }

    public AuthorizationData getAuthorizationData() {
        return this.authorizationData;
    }

    public KerberosTime getAuthTime() {
        return this.authtime;
    }

    public HostAddresses getClientAddresses() {
        return this.clientAddresses;
    }

    public KerberosPrincipal getClientPrincipal() {
        return this.clientPrincipal;
    }

    public String getClientRealm() {
        return this.clientPrincipal.getRealm();
    }

    public KerberosTime getEndTime() {
        return this.endTime;
    }

    public TicketFlags getFlags() {
        return this.flags;
    }

    public EncryptionKey getSessionKey() {
        return this.sessionKey;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public KerberosTime getStartTime() {
        return this.startTime;
    }

    public TransitedEncoding getTransitedEncoding() {
        return this.transitedEncoding;
    }
}

