/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.platform.portal.notifications.automation;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.notification.api.NotificationManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="Notification.HandleNotification", category="Notification", label="Handle subsciptions to notifications", description="Subscribe/unsubscribe a principal to notification(s).WARNING! The parameter 'userid' can either be prefixed 'user:' or 'group:' to explicitely define the directory it belongs to. If not prefixed, a directory seacrch will be performedto deternmine the user type 'user' or 'group'")
public class HandleNotification {
    protected static final Log log = LogFactory.getLog(HandleNotification.class);
    public static final String ID = "Notification.HandleNotification";
    public static final String NOTIFICATION_ACTION_ADD = "ADD";
    public static final String NOTIFICATION_ACTION_REMOVE = "REMOVE";
    public static final String NOTIFICATION_PREFIXE_USER = "user:";
    public static final String NOTIFICATION_PREFIXE_GROUP = "group:";
    @Context
    protected OperationContext ctx;
    @Context
    protected UserManager userManager;
    @Context
    protected NotificationManager notificationManager;
    @Param(name="userid", required=true, description="Can either be prefixed 'user:' or 'group:' to explicitely define the directory it belongs to")
    protected String userid;
    @Param(name="notifications", required=true)
    protected StringList notifications;
    @Param(name="sendEmail", required=false, values={"false", "true"})
    protected boolean sendEmail = false;
    @Param(name="action", required=true, values={"ADD", "REMOVE"})
    protected String action = "ADD";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel document) throws Exception {
        String prefixedUserId = this.userid;
        if (!this.userid.matches("^(user:|group:).+")) {
            Boolean isUser = null != this.userManager.getPrincipal(this.userid);
            Boolean isGroup = null != this.userManager.getGroup(this.userid);
            if (isUser.booleanValue() && !isGroup.booleanValue()) {
                prefixedUserId = NOTIFICATION_PREFIXE_USER + this.userid;
            } else if (!isUser.booleanValue() && isGroup.booleanValue()) {
                prefixedUserId = NOTIFICATION_PREFIXE_GROUP + this.userid;
            } else {
                if (!isUser.booleanValue()) {
                    log.error((Object)("The userid parameter '" + this.userid + "' could not be found within either the user or group LDAP directories"));
                } else {
                    log.error((Object)("The userid parameter '" + this.userid + "' is ambiguous since was found both within the user and the group LDAP directories"));
                }
                return document;
            }
        }
        if (NOTIFICATION_ACTION_ADD.equals(this.action)) {
            NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
            for (String notification : this.notifications) {
                List subscribers = this.notificationManager.getSubscribers(notification, document.getId());
                if (subscribers.contains(prefixedUserId)) continue;
                this.notificationManager.addSubscription(prefixedUserId, notification, document, Boolean.valueOf(this.sendEmail), principal, notification);
            }
            log.info((Object)("Subscibed user '" + this.userid + "' to the notification '" + this.notifications + "' on document '" + document.getPathAsString() + "' (UUID=" + document.getId() + ")"));
        } else {
            for (String notification : this.notifications) {
                this.notificationManager.removeSubscription(prefixedUserId, notification, document.getId());
            }
            log.info((Object)("Unsubscibed user '" + this.userid + "' to the notification '" + this.notifications + "' on document '" + document.getPathAsString() + "' (UUID=" + document.getId() + ")"));
        }
        return document;
    }
}

