/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.plarform.web.filemanager;

import fr.toutatice.ecm.platform.service.quota.QuotaService;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.component.file.InputFileInfo;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.runtime.api.Framework;

@Name(value="ottcFileValidator")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class FileValidatorBean
implements Serializable {
    private static final long serialVersionUID = 6142695676085523525L;
    public static final String[] MEDIA_PRIMARY_MIME_TYPES = new String[]{"image", "audio", "video"};
    @In(create=true, required=false)
    protected CoreSession documentManager;
    @In
    protected DocumentModel currentDocument;
    private static final String[] UNITS = new String[]{"o", "Ko", "Mo", "Go", "To"};
    private static final double UNIT_FACTOR = 1024.0;

    public void validateMimeType(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (value != null) {
            InputFileInfo file = (InputFileInfo)value;
            try {
                MimeType mimeType = new MimeType((String)file.getMimeType());
                if (ArrayUtils.contains((Object[])MEDIA_PRIMARY_MIME_TYPES, (Object)mimeType.getPrimaryType())) {
                    String msg = ComponentUtils.translate((FacesContext)context, (String)"ottc.validator.file.bad.mime.type");
                    FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                    throw new ValidatorException(message);
                }
            }
            catch (MimeTypeParseException e) {
                String msg = ComponentUtils.translate((FacesContext)context, (String)"ottc.validator.file.unknown.mime.type");
                FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
                throw new ValidatorException(message);
            }
        }
    }

    public String getFreeSpace() {
        Long freeSpace;
        QuotaService qs;
        String propertyWidgetMaxSize = Framework.getProperty((String)"ottc.widget.filemaxSize");
        String propertyWidgetMaxSizeInt = Framework.getProperty((String)"ottc.widget.filemaxSize.long");
        long propertyWidgetInLong = Long.parseLong(propertyWidgetMaxSizeInt);
        String freeSpaceStr = "";
        if (StringUtils.isNotBlank((String)propertyWidgetMaxSize)) {
            freeSpaceStr = propertyWidgetMaxSize;
        }
        if ((qs = (QuotaService)Framework.getService(QuotaService.class)) != null && (freeSpace = qs.getFreeSpace(this.documentManager, this.currentDocument)) != null) {
            if (freeSpace < 1000000L) {
                return "1Ko";
            }
            if (freeSpace < propertyWidgetInLong) {
                int factor = Double.valueOf(Math.log10(freeSpace.longValue()) / Math.log10(1024.0)).intValue();
                double factorizedSize = (double)freeSpace.longValue() / Math.pow(1024.0, factor);
                String unit = I18NUtils.getMessageString((String)"messages", (String)UNITS[factor], null, (Locale)Locale.getDefault());
                NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.getDefault());
                numberFormat.setMaximumFractionDigits(0);
                freeSpaceStr = numberFormat.format(factorizedSize) + unit;
            }
        }
        return freeSpaceStr;
    }
}

