/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.plarform.web.filemanager;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.filemanager.FileManageActionsBean;
import org.nuxeo.ecm.webapp.filemanager.NxUploadedFile;
import org.nuxeo.runtime.api.Framework;

@Name(value="toutaticeFileManageActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class ToutaticeFileManageActionsBean
extends FileManageActionsBean {
    private static final Log log = LogFactory.getLog(FileManageActionsBean.class);

    public void performAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        try {
            DocumentModel current = ((ToutaticeDocumentActionsBean)this.documentActions).getCurrentDocument();
            if (!current.hasSchema("files")) {
                return;
            }
            ArrayList files = (ArrayList)current.getPropertyValue("files:files");
            Object file = CollectionUtils.get((Object)files, (int)Integer.valueOf(index));
            files.remove(file);
            current.setPropertyValue("files:files", (Serializable)files);
            if (!ToutaticeDocumentHelper.isEmptyDocumentModel((DocumentModel)current)) {
                this.documentActions.updateDocument(current, Boolean.TRUE);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateMultipleUploadForDocument(DocumentModel current) throws ClientException, FileNotFoundException, IOException {
        if (!current.hasSchema("files")) {
            return;
        }
        Collection nxuploadFiles = this.getUploadedFiles();
        try {
            ArrayList files = (ArrayList)current.getPropertyValue("files:files");
            if (nxuploadFiles != null) {
                for (NxUploadedFile uploadItem : nxuploadFiles) {
                    String filename = FileUtils.getCleanFileName((String)uploadItem.getName());
                    Blob blob = FileUtils.createTemporaryFileBlob((File)uploadItem.getFile(), (String)filename, (String)uploadItem.getContentType());
                    HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
                    fileMap.put("file", blob);
                    fileMap.put("filename", filename);
                    if (files.contains(fileMap)) continue;
                    files.add(fileMap);
                }
            }
            current.setPropertyValue("files:files", (Serializable)files);
            if (!ToutaticeDocumentHelper.isEmptyDocumentModel((DocumentModel)current)) {
                this.documentActions.updateDocument(current, Boolean.TRUE);
            }
        }
        finally {
            if (nxuploadFiles != null) {
                for (NxUploadedFile uploadItem : nxuploadFiles) {
                    File tempFile = uploadItem.getFile();
                    if (tempFile == null || !tempFile.exists()) continue;
                    Framework.trackFile((File)tempFile, (Object)tempFile);
                }
            }
        }
    }
}

