/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.collaborative.space;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentMetadataHelper;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;

@Name(value="csFormValidator")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class CollaborativeSpaceFormValidatorBean
implements Serializable {
    private static final long serialVersionUID = -6037133994828912338L;
    @In(create=true, required=true)
    protected transient CoreSession documentManager;
    @In(create=true, required=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=true)
    protected transient DocumentActions documentActions;

    public void validateTitle(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (((ToutaticeDocumentActionsBean)this.documentActions).belongToWorkSpace() && !this.isTileUnique((String)value)) {
            String msg = ComponentUtils.translate((FacesContext)context, (String)"label.cs.validator.no.unique.title");
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, msg, null);
            throw new ValidatorException(message);
        }
    }

    public boolean isTileUnique(String title) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            DocumentModel parentDocument;
            String currentUUId = null;
            String parentUUId = null;
            DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
            if (changeableDocument != null) {
                parentDocument = currentDocument;
                parentUUId = currentDocument.getId();
            } else {
                parentDocument = this.documentManager.getParentDocument(currentDocument.getRef());
                parentUUId = parentDocument.getId();
                currentUUId = currentDocument.getId();
            }
            boolean sameTitleAllowed = ToutaticeDocumentMetadataHelper.isSameTitleAllowed((String)parentDocument.getType());
            if (sameTitleAllowed) {
                return true;
            }
            return ToutaticeDocumentMetadataHelper.isTileUnique((CoreSession)this.documentManager, (String)parentUUId, (String)currentUUId, (String)title);
        }
        return false;
    }
}

