/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.fragments;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;

@Name(value="pageBean")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=30)
public class PageBean
implements Serializable {
    private static final long serialVersionUID = -8405154430255486965L;
    private static final Log log = LogFactory.getLog(PageBean.class);
    private static String REQUEST_PARAM_SEPARATOR = "=";
    private static final String CONVERSATION_ID = "conversationId" + REQUEST_PARAM_SEPARATOR;
    private static final String CONVERSATION_ID_REGEXP = "conversationId=([^&]+)";
    @In(create=true, required=true)
    protected transient CoreSession documentManager;
    private boolean isConversationStarted = false;
    private String conversationId;
    private String fromUrl;
    protected String notificationKey;
    protected String liveEditLink;
    @RequestParameter(value="fromUrl")
    private String requestedFromUrl;
    @RequestParameter(value="callBackContext")
    private String callBackContext;
    @RequestParameter(value="docId")
    private String inputDocId;

    public String getNotificationKey() {
        String notif = this.notificationKey;
        this.setNotificationKey(null);
        return notif;
    }

    public void setNotificationKey(String notificationKey) {
        this.notificationKey = notificationKey;
    }

    public String getInputDocId() {
        return this.inputDocId;
    }

    public void setInputDocId(String inputDocId) {
        this.inputDocId = inputDocId;
    }

    public String getFromUrl() {
        return this.fromUrl;
    }

    public void setFromUrl(String fromUrl) {
        this.fromUrl = fromUrl;
    }

    public String getCallBackContext() {
        return this.callBackContext;
    }

    public void setCallBackContext(String callBackContext) {
        this.callBackContext = callBackContext;
    }

    public String getLiveEditLink() {
        IdRef docRef = new IdRef(this.inputDocId);
        try {
            DocumentModel document = this.documentManager.getDocument((DocumentRef)docRef);
            this.liveEditLink = DocumentModelFunctions.liveEditUrl((DocumentModel)document);
            if (this.isConversationStarted) {
                this.liveEditLink.replaceAll(CONVERSATION_ID_REGEXP, CONVERSATION_ID + this.conversationId);
            } else {
                this.isConversationStarted = true;
                this.conversationId = this.getConversationId(this.liveEditLink);
            }
            return this.liveEditLink;
        }
        catch (ClientException e) {
            log.error((Object)e);
            return null;
        }
    }

    public void setLiveEditLink(String liveEditLink) {
        this.liveEditLink = liveEditLink;
    }

    @Create
    public void startUp() {
        if (this.requestedFromUrl != null) {
            this.fromUrl = this.requestedFromUrl;
        }
    }

    private String getConversationId(String url) {
        Pattern pattern = Pattern.compile(CONVERSATION_ID_REGEXP);
        Matcher matcher = pattern.matcher(url);
        if (matcher.find()) {
            String conversationKeyValue = matcher.group(0);
            return conversationKeyValue.split(REQUEST_PARAM_SEPARATOR)[1];
        }
        return null;
    }
}

