/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.imagemanager;

import fr.toutatice.ecm.platform.core.helper.ToutaticeFileHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeImageCollectionHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.files.FileUtils;
import org.nuxeo.ecm.webapp.filemanager.FileManageActionsBean;
import org.nuxeo.ecm.webapp.filemanager.NxUploadedFile;

@Name(value="ImageManagerActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=31)
public class ToutaticeImageManagerActionsBean
extends FileManageActionsBean {
    private static final Log log = LogFactory.getLog(ToutaticeImageManagerActionsBean.class);
    private List<imageBean> imageBeanslist;

    public List<imageBean> getImageBeanslist() {
        if (null == this.imageBeanslist) {
            this.imageBeanslist = new ArrayList<imageBean>();
        } else {
            this.imageBeanslist.clear();
        }
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (currentDocument.hasSchema("toutatice")) {
                List images = (List)((Object)currentDocument.getPropertyValue("ttc:images"));
                for (int index = 0; index < images.size(); ++index) {
                    Map image = (Map)images.get(index);
                    if (ToutaticeImageCollectionHelper.instance().isFakeItem(image)) continue;
                    String complexURL = DocumentModelFunctions.complexFileUrl((String)"downloadFile", (DocumentModel)currentDocument, (String)"ttc:images", (int)index, (String)"file", (String)((String)image.get("filename")));
                    this.imageBeanslist.add(new imageBean(index, (String)image.get("filename"), complexURL));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to set list of images index, error: " + e.getMessage()));
        }
        return this.imageBeanslist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatAttachablesPicturesForDocument(DocumentModel current) throws ClientException, FileNotFoundException {
        ArrayList<String> msg_params = new ArrayList<String>();
        if (!current.hasSchema("toutatice")) {
            return;
        }
        try {
            List files = (List)((Object)current.getPropertyValue("ttc:images"));
            for (NxUploadedFile uploadItem : this.getUploadedFiles()) {
                String filename = FileUtils.getCleanFileName((String)uploadItem.getName());
                Blob blob = FileUtils.createSerializableBlob((InputStream)new FileInputStream(uploadItem.getFile()), (String)filename, null);
                if (ToutaticeFileHelper.instance().isImageTypeFile(filename, blob)) {
                    HashMap<String, Object> fileMap = new HashMap<String, Object>(2);
                    fileMap.put("file", blob);
                    fileMap.put("filename", filename);
                    if (files.contains(fileMap)) continue;
                    ToutaticeImageCollectionHelper.instance().add(files, fileMap);
                    continue;
                }
                msg_params.add(filename);
            }
            if (!msg_params.isEmpty()) {
                this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.messages.get("toutatice.fileImporter.error.mimetype.image"), new Object[]{this.formatParamsToString(msg_params)});
            }
            current.setPropertyValue("ttc:images", (Serializable)((Object)files));
            this.documentManager.saveDocument(current);
            this.documentManager.save();
        }
        finally {
            for (NxUploadedFile uploadItem : this.getUploadedFiles()) {
                uploadItem.getFile().delete();
            }
        }
        Contexts.getConversationContext().remove("fileUploadHolder");
    }

    public void performAction(ActionEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        try {
            DocumentModel current = this.navigationContext.getCurrentDocument();
            if (!current.hasSchema("toutatice")) {
                return;
            }
            List files = (List)((Object)current.getPropertyValue("ttc:images"));
            Object file = CollectionUtils.get((Object)files, (int)new Integer(index));
            ToutaticeImageCollectionHelper.instance().remove(files, file);
            current.setPropertyValue("ttc:images", (Serializable)((Object)files));
            this.documentManager.saveDocument(current);
            this.documentManager.save();
        }
        catch (Exception e) {
            log.error((Object)("Failed to remove the attached image, error: " + e.getMessage()));
        }
    }

    public void createImageStamp() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        String index = (String)eContext.getRequestParameterMap().get("index");
        try {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            if (!currentDocument.hasSchema("toutatice")) {
                return;
            }
            Collection files = (Collection)((Object)currentDocument.getPropertyValue("ttc:images"));
            Map file = (Map)CollectionUtils.get((Object)files, (int)new Integer(index));
            currentDocument.setPropertyValue("ttc:vignette", (Serializable)file.get("file"));
            this.documentManager.saveDocument(currentDocument);
            this.facesMessages.addFromResourceBundle(StatusMessage.Severity.INFO, (String)this.messages.get("toutatice.fileImporter.create.success.stamp"), new Object[0]);
            this.fetchCurrentDocument(currentDocument);
        }
        catch (Exception e) {
            log.error((Object)("Failed to generate the stamp image, error: " + e.getMessage()));
        }
    }

    private String formatParamsToString(List<String> params) {
        String toString = null;
        for (String param : params) {
            if (StringUtils.isBlank(toString)) {
                toString = param;
                continue;
            }
            toString = toString + ", " + param;
        }
        return toString;
    }

    public void fetchCurrentDocument(DocumentModel document) throws ClientException {
        this.navigationContext.invalidateCurrentDocument();
    }

    public class imageBean {
        private int index;
        private String filename;
        private String fileURL;

        public imageBean(int index, String filename, String fileURL) {
            this.setIndex(index);
            this.setFilename(filename);
            this.setFileURL(fileURL);
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getFileURL() {
            return this.fileURL;
        }

        public void setFileURL(String fileURL) {
            this.fileURL = fileURL;
        }
    }
}

