/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.webeditor;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeSorterHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.webapp.action.EditorLinkActionsBean;

@Name(value="editorLinkActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticeEditorLinkActionsBean
extends EditorLinkActionsBean {
    private static final String TOUT = "TOUT";
    private static final String DOMAIN = "DOMAIN";
    private static final String ESPACE = "ESPACE";
    private static final String MEDIALIBRARY = "MEDIALIBRARY";
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ToutaticeEditorLinkActionsBean.class);
    private static final String SEARCH_QUERY = "SELECT * FROM Document WHERE %s";
    private String typeDoc = "TOUS";
    private String scope = "ESPACE";
    private Map<String, Object> types;
    private Map<String, String> scopes;
    @In(create=true)
    protected Map<String, String> messages;
    private List<DocumentModel> resultDocuments;
    private String searchKeywords;
    private boolean hasSearchResults = false;
    private DocumentModel mediaSpace;
    @In(create=true, required=false)
    private CoreSession documentManager;
    @In(create=true, required=false)
    private SchemaManager schemaManager;

    public String getMediaSpaceName() throws ClientException {
        if (this.getMediaSpace() != null) {
            return this.getMediaSpace().getTitle();
        }
        return null;
    }

    private DocumentModel getMediaSpace() throws ClientException {
        this.mediaSpace = null;
        DocumentModel currentDomain = this.navigationContext.getCurrentDomain();
        if (currentDomain != null) {
            String searchMediaLibraries = "ecm:primaryType = 'MediaLibrary' and ecm:path startswith '" + currentDomain.getPathAsString() + "' and ecm:isCheckedInVersion = 0 AND ecm:isProxy = 0 AND ecm:currentLifeCycleState!='deleted'";
            String queryMediaLibraries = String.format(SEARCH_QUERY, searchMediaLibraries);
            DocumentModelList query = this.documentManager.query(queryMediaLibraries);
            if (query.size() == 1) {
                this.mediaSpace = (DocumentModel)query.get(0);
            }
        }
        return this.mediaSpace;
    }

    private String getSpaceName() throws ClientException {
        String res = null;
        DocumentModel space = this.navigationContext.getCurrentSuperSpace();
        if (space != null) {
            res = space.getTitle();
        }
        return res;
    }

    private String getDomaineName() throws ClientException {
        String res = null;
        DocumentModel domain = this.navigationContext.getCurrentDomain();
        if (domain != null) {
            res = domain.getTitle();
        }
        return res;
    }

    public Map<String, String> getScopes() throws ClientException {
        this.scopes = new HashMap<String, String>();
        if (this.getMediaSpace() != null) {
            this.scopes.put(this.getMediaSpaceName(), MEDIALIBRARY);
        }
        this.scopes.put(this.getSpaceName(), ESPACE);
        this.scopes.put(this.getDomaineName(), DOMAIN);
        this.scopes.put("Tout nuxeo", TOUT);
        return this.scopes;
    }

    public void setScopes(Map<String, String> scopes) {
        this.scopes = scopes;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getTypeDoc() {
        return this.typeDoc;
    }

    public void setTypeDoc(String typeDoc) {
        this.typeDoc = typeDoc;
    }

    public List<DocumentModel> getResultDocuments() {
        return this.resultDocuments;
    }

    public void setTypes(Map<String, Object> types) {
        this.types = types;
    }

    public Map<String, Object> getTypes() throws ClientException {
        this.types = new TreeMap<String, Object>();
        Collection collectTypes = this.typeManager.getTypes();
        if (MEDIALIBRARY.equals(this.scope)) {
            collectTypes = this.typeManager.findAllAllowedSubTypesFrom(this.getMediaSpace().getType(), this.getMediaSpace());
        } else if (ESPACE.equals(this.scope)) {
            collectTypes = this.typeManager.findAllAllowedSubTypesFrom(this.navigationContext.getCurrentSuperSpace().getType(), this.navigationContext.getCurrentSuperSpace());
        } else if (DOMAIN.equals(this.scope)) {
            collectTypes = this.typeManager.findAllAllowedSubTypesFrom(this.navigationContext.getCurrentDomain().getType(), this.navigationContext.getCurrentDomain());
        } else {
            collectTypes.clear();
        }
        ArrayList lstType = new ArrayList(collectTypes);
        this.types.put("Tous", "TOUS");
        for (Type type : lstType) {
            if (!"SimpleDocument".equalsIgnoreCase(type.getCategory())) continue;
            String label = this.messages.get(type.getId());
            this.types.put(label, type.getId());
        }
        return this.types;
    }

    public List<DocumentModel> getSearchDocumentResults() {
        return this.resultDocuments;
    }

    public void setResultDocuments(List<DocumentModel> resultDocuments) {
        this.resultDocuments = resultDocuments;
    }

    public String getSearchKeywords() {
        return this.searchKeywords;
    }

    public void setSearchKeywords(String searchKeywords) {
        this.searchKeywords = searchKeywords;
    }

    public boolean getHasSearchResults() {
        return this.hasSearchResults;
    }

    public String searchDocuments(String view) throws ClientException {
        this.searchDocuments();
        return view;
    }

    public String searchDocuments() throws ClientException {
        this.resultDocuments = null;
        ArrayList<String> constraints = new ArrayList<String>();
        int queryLimitResults = 101;
        if (MEDIALIBRARY.equals(this.scope)) {
            constraints.add("ecm:path STARTSWITH '" + this.getMediaSpace().getPathAsString().replace("'", "\\'") + "'");
        }
        if (ESPACE.equals(this.scope)) {
            constraints.add("ecm:path STARTSWITH '" + this.navigationContext.getCurrentSuperSpace().getPathAsString().replace("'", "\\'") + "'");
        } else if (DOMAIN.equals(this.scope)) {
            constraints.add("ecm:path STARTSWITH '" + this.navigationContext.getCurrentDomain().getPathAsString().replace("'", "\\'") + "'");
        }
        if (this.typeDoc != null && !"TOUS".equals(this.typeDoc)) {
            constraints.add("ecm:primaryType = '" + this.getTypeDoc() + "'");
        }
        if (this.searchKeywords != null) {
            this.searchKeywords = this.searchKeywords.trim();
            if (this.searchKeywords.length() > 0 && !this.searchKeywords.equals("*")) {
                constraints.add(String.format("ecm:fulltext LIKE '%s%%'", this.searchKeywords.replace("'", "\\'")));
            }
        }
        constraints.add("ecm:mixinType <> 'HiddenInNavigation' and ecm:mixinType <> 'OttcDraft'");
        constraints.add("(ecm:mixinType = 'isRemoteProxy' or ecm:isProxy = 0) AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState!='deleted'");
        String query = String.format(SEARCH_QUERY, StringUtils.join((Object[])constraints.toArray(), (String)" AND "));
        log.debug((Object)("Query: " + query));
        this.resultDocuments = this.documentManager.query(query, 101);
        this.hasSearchResults = !this.resultDocuments.isEmpty();
        log.debug((Object)("query result contains: " + this.resultDocuments.size() + " docs."));
        return "editor_link_search_document";
    }

    public DocumentModelList getRemotePublishedDocuments(DocumentModel document) {
        return ToutaticeDocumentHelper.getRemotePublishedDocuments((CoreSession)this.documentManager, (DocumentModel)document);
    }

    private class ListTypeComparator
    extends ToutaticeSorterHelper<Type> {
        private ListTypeComparator() {
        }

        public String getComparisionString(Type type) {
            String stg = "";
            try {
                stg = type.getLabel();
            }
            catch (Exception e) {
                log.error((Object)("Failed to extract the comparision string to Type, error:" + e.getMessage()));
            }
            return stg;
        }
    }
}

