/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.workflows;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import fr.toutatice.ecm.platform.web.workflows.ToutaticeDocumentRoutingActionsBean;
import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.routing.web.RoutingTaskActionsBean;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskImpl;
import org.nuxeo.ecm.platform.task.TaskService;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="routingTaskActions")
@Install(precedence=31)
public class ToutaticeRoutingTaskActionsBean
extends RoutingTaskActionsBean {
    private static final long serialVersionUID = -5854741772106895168L;
    private static final List<String> TOUTATICE_WF_ONLINE_ACTIONS = new ArrayList<String>(){
        private static final long serialVersionUID = 3710687789887853309L;
        {
            this.add("workflow_online_accept");
            this.add("workflow_online_reject");
        }
    };
    @In
    TaskService taskService;
    @In(create=true)
    ToutaticeDocumentRoutingActionsBean routingActions;

    public String getClickedButton() {
        return this.button;
    }

    public String getWorkFlowInitiator() throws ClientException {
        return this.routingActions.getCurrentWorkflowInitiator();
    }

    public String endTask(Task task) throws ClientException {
        String view = "view_documents";
        if (TOUTATICE_WF_ONLINE_ACTIONS.contains(this.getClickedButton())) {
            DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
            TaskImpl taskForNotif = new TaskImpl(task.getDocument());
            String wfInitiator = this.getWorkFlowInitiator();
            String eventName = "workflow_online_accept".equalsIgnoreCase(this.getClickedButton()) ? "workflowOnlineTaskApproved" : "workflowOnlineTaskRejected";
            super.endTask(task);
            ToutaticeWorkflowHelper.notifyRecipients((CoreSession)this.documentManager, (Task)taskForNotif, (DocumentModel)currentDoc, (String)wfInitiator, (String)eventName);
        } else {
            view = super.endTask(task);
        }
        return view;
    }
}

