/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.log4j;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.DefaultRepositorySelector;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RootLogger;
import org.apache.log4j.varia.LevelRangeFilter;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4JHelper {
    private static final Log log = LogFactory.getLog(Log4JHelper.class);
    public static final String CONSOLE_APPENDER_NAME = "CONSOLE";
    protected static final String FULL_PATTERN_LAYOUT = "%d{HH:mm:ss,SSS} %-5p [%l] %m%n";
    protected static final String LIGHT_PATTERN_LAYOUT = "%m%n";

    public static ArrayList<String> getFileAppendersFiles(LoggerRepository loggerRepository) {
        ArrayList<String> logFiles = new ArrayList<String>();
        Enumeration appenders = loggerRepository.getRootLogger().getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof FileAppender)) continue;
            FileAppender fileAppender = (FileAppender)appender;
            logFiles.add(fileAppender.getFile());
        }
        Enumeration currentLoggers = loggerRepository.getCurrentLoggers();
        while (currentLoggers.hasMoreElements()) {
            Logger logger = (Logger)currentLoggers.nextElement();
            Enumeration appenders2 = logger.getAllAppenders();
            while (appenders2.hasMoreElements()) {
                Appender appender = (Appender)appenders2.nextElement();
                if (!(appender instanceof FileAppender)) continue;
                FileAppender fileAppender = (FileAppender)appender;
                logFiles.add(fileAppender.getFile());
            }
        }
        return logFiles;
    }

    public static LoggerRepository getNewLoggerRepository(File log4jConfigurationFile) {
        LoggerRepository loggerRepository = null;
        try {
            loggerRepository = new DefaultRepositorySelector((LoggerRepository)new Hierarchy((Logger)new RootLogger(Level.DEBUG))).getLoggerRepository();
            if (log4jConfigurationFile == null || !log4jConfigurationFile.exists()) {
                log.error((Object)("Missing Log4J configuration: " + log4jConfigurationFile));
            } else {
                new DOMConfigurator().doConfigure(log4jConfigurationFile.toURI().toURL(), loggerRepository);
                log.debug((Object)("Log4j configuration " + log4jConfigurationFile + " successfully loaded."));
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)("Could not load " + log4jConfigurationFile), (Throwable)e);
        }
        return loggerRepository;
    }

    public static ArrayList<String> getFileAppendersFiles(File log4jConfigurationFile) {
        return Log4JHelper.getFileAppendersFiles(Log4JHelper.getNewLoggerRepository(log4jConfigurationFile));
    }

    public static void setDebug(String categories, boolean debug, boolean includeChildren, String[] appenderNames) {
        String[] categoriesArray;
        Level newLevel = debug ? Level.DEBUG : Level.INFO;
        for (String category : categoriesArray = categories.split(",")) {
            Logger logger = Logger.getLogger((String)category);
            logger.setLevel(newLevel);
            log.info((Object)("Log level set to " + newLevel + " for: " + logger.getName()));
        }
        if (includeChildren) {
            Enumeration loggers = LogManager.getCurrentLoggers();
            block1: while (loggers.hasMoreElements()) {
                Logger logger = (Logger)loggers.nextElement();
                if (logger.getLevel() == newLevel) continue;
                for (String category : categoriesArray) {
                    if (!logger.getName().startsWith(category)) continue;
                    logger.setLevel(newLevel);
                    log.info((Object)("Log level set to " + newLevel + " for: " + logger.getName()));
                    continue block1;
                }
            }
        }
        if (ArrayUtils.isEmpty((Object[])appenderNames)) {
            return;
        }
        for (String appenderName : appenderNames) {
            Filter filter;
            Appender consoleAppender = Logger.getRootLogger().getAppender(appenderName);
            if (consoleAppender == null) continue;
            for (filter = consoleAppender.getFilter(); filter != null && !(filter instanceof LevelRangeFilter); filter = filter.getNext()) {
            }
            if (filter != null) {
                LevelRangeFilter levelRangeFilter = (LevelRangeFilter)filter;
                levelRangeFilter.setLevelMin(Level.DEBUG);
                log.debug((Object)("Log level filter set to DEBUG for appender " + appenderName));
            }
            String patternLayout = debug ? FULL_PATTERN_LAYOUT : LIGHT_PATTERN_LAYOUT;
            consoleAppender.setLayout((Layout)new PatternLayout(patternLayout));
            log.info((Object)String.format("Set pattern layout of %s to %s", appenderName, patternLayout));
        }
    }

    public static void setDebug(String category, boolean debug) {
        Log4JHelper.setDebug(category, debug, false, new String[]{CONSOLE_APPENDER_NAME});
    }

    public static void setQuiet(String appenderName) {
        Filter filter;
        Appender appender = Logger.getRootLogger().getAppender(appenderName);
        if (appender == null) {
            return;
        }
        for (filter = appender.getFilter(); filter != null && !(filter instanceof LevelRangeFilter); filter = filter.getNext()) {
        }
        if (filter != null) {
            LevelRangeFilter levelRangeFilter = (LevelRangeFilter)filter;
            levelRangeFilter.setLevelMin(Level.WARN);
            log.debug((Object)("Log level filter set to WARN for appender " + appenderName));
        }
    }
}

