/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.content.template.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.platform.content.template.listener.RepositoryInitializationListener;
import org.nuxeo.ecm.platform.content.template.service.ContentFactory;
import org.nuxeo.ecm.platform.content.template.service.ContentFactoryDescriptor;
import org.nuxeo.ecm.platform.content.template.service.ContentTemplateService;
import org.nuxeo.ecm.platform.content.template.service.FactoryBindingDescriptor;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandlerDescriptor;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandlerRegistry;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ContentTemplateServiceImpl
extends DefaultComponent
implements ContentTemplateService {
    public static final String NAME = "org.nuxeo.ecm.platform.content.template.service.TemplateService";
    public static final String FACTORY_DECLARATION_EP = "factory";
    public static final String FACTORY_BINDING_EP = "factoryBinding";
    public static final String POST_CONTENT_CREATION_HANDLERS_EP = "postContentCreationHandlers";
    private static final Log log = LogFactory.getLog(ContentTemplateServiceImpl.class);
    private final Map<String, ContentFactoryDescriptor> factories = new HashMap<String, ContentFactoryDescriptor>();
    private final Map<String, FactoryBindingDescriptor> factoryBindings = new HashMap<String, FactoryBindingDescriptor>();
    private final Map<String, ContentFactory> factoryInstancesByType = new HashMap<String, ContentFactory>();
    private final Map<String, ContentFactory> factoryInstancesByFacet = new HashMap<String, ContentFactory>();
    private PostContentCreationHandlerRegistry postContentCreationHandlers;
    private RepositoryInitializationHandler initializationHandler;

    public void activate(ComponentContext context) {
        this.initializationHandler = new RepositoryInitializationListener();
        this.initializationHandler.install();
        this.postContentCreationHandlers = new PostContentCreationHandlerRegistry();
    }

    public void deactivate(ComponentContext context) throws Exception {
        if (this.initializationHandler != null) {
            this.initializationHandler.uninstall();
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        block15: {
            if (extensionPoint.equals(FACTORY_DECLARATION_EP)) {
                ContentFactoryDescriptor descriptor = (ContentFactoryDescriptor)contribution;
                this.factories.put(descriptor.getName(), descriptor);
            } else if (extensionPoint.equals(FACTORY_BINDING_EP)) {
                FactoryBindingDescriptor descriptor = (FactoryBindingDescriptor)contribution;
                if (this.factories.containsKey(descriptor.getFactoryName())) {
                    String targetType = descriptor.getTargetType();
                    String targetFacet = descriptor.getTargetFacet();
                    if (descriptor.getAppend().booleanValue()) {
                        descriptor = this.mergeFactoryBindingDescriptor(descriptor);
                    }
                    if (null != targetType) {
                        this.factoryBindings.put(targetType, descriptor);
                    } else {
                        this.factoryBindings.put(targetFacet, descriptor);
                    }
                    ContentFactoryDescriptor factoryDescriptor = this.factories.get(descriptor.getFactoryName());
                    try {
                        ContentFactory factory = factoryDescriptor.getClassName().newInstance();
                        Boolean factoryOK = factory.initFactory(descriptor.getOptions(), descriptor.getRootAcl(), descriptor.getTemplate());
                        if (!factoryOK.booleanValue()) {
                            log.error((Object)("Error while initializing instance of factory " + factoryDescriptor.getName()));
                            return;
                        }
                        if (null != targetType) {
                            this.factoryInstancesByType.put(targetType, factory);
                            break block15;
                        }
                        this.factoryInstancesByFacet.put(targetFacet, factory);
                    }
                    catch (InstantiationException e) {
                        log.error((Object)("Error while creating instance of factory " + factoryDescriptor.getName() + " :" + e.getMessage()));
                    }
                    catch (IllegalAccessException e) {
                        log.error((Object)("Error while creating instance of factory " + factoryDescriptor.getName() + " :" + e.getMessage()));
                    }
                } else {
                    log.error((Object)("Factory Binding" + descriptor.getName() + " can not be registered since Factory " + descriptor.getFactoryName() + " is not registered"));
                }
            } else if (POST_CONTENT_CREATION_HANDLERS_EP.equals(extensionPoint)) {
                PostContentCreationHandlerDescriptor descriptor = (PostContentCreationHandlerDescriptor)contribution;
                this.postContentCreationHandlers.addContribution(descriptor);
            }
        }
    }

    private FactoryBindingDescriptor mergeFactoryBindingDescriptor(FactoryBindingDescriptor newOne) {
        FactoryBindingDescriptor old = null;
        old = null != newOne.getTargetType() ? this.factoryBindings.get(newOne.getTargetType()) : this.factoryBindings.get(newOne.getTargetFacet());
        if (old != null) {
            log.info((Object)("FactoryBinding " + old.getName() + " is merging with " + newOne.getName()));
            old.getOptions().putAll(newOne.getOptions());
            old.getRootAcl().addAll(newOne.getRootAcl());
            old.getTemplate().addAll(newOne.getTemplate());
            return old;
        }
        return newOne;
    }

    @Override
    public ContentFactory getFactoryForType(String documentType) {
        return this.factoryInstancesByType.get(documentType);
    }

    public ContentFactory getFactoryForFacet(String facet) {
        return this.factoryInstancesByFacet.get(facet);
    }

    @Override
    public void executeFactoryForType(DocumentModel createdDocument) throws ClientException {
        ContentFactory factory = this.getFactoryForType(createdDocument.getType());
        if (factory != null) {
            factory.createContentStructure(createdDocument);
        }
        Set facets = createdDocument.getFacets();
        for (String facet : facets) {
            factory = this.getFactoryForFacet(facet);
            if (factory == null) continue;
            factory.createContentStructure(createdDocument);
        }
    }

    @Override
    public void executePostContentCreationHandlers(CoreSession session) {
        for (PostContentCreationHandler handler : this.postContentCreationHandlers.getOrderedHandlers()) {
            handler.execute(session);
        }
    }

    public Map<String, ContentFactoryDescriptor> getFactories() {
        return this.factories;
    }

    public Map<String, FactoryBindingDescriptor> getFactoryBindings() {
        return this.factoryBindings;
    }

    public Map<String, ContentFactory> getFactoryInstancesByType() {
        return this.factoryInstancesByType;
    }

    public Map<String, ContentFactory> getFactoryInstancesByFacet() {
        return this.factoryInstancesByFacet;
    }
}

