/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.file.naming.listeners;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.file.naming.constants.FileNamingConstants;
import fr.toutatice.ecm.platform.file.naming.helper.ToutaticeFileNamingHelper;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ToutaticeFileNamingListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext ctx = (DocumentEventContext)event.getContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel document = ctx.getSourceDocument();
            String eventName = event.getName();
            if (("documentCreated".equals(eventName) || "documentModified".equals(eventName)) && FileNamingConstants.SUPPORTED_DOC_TYPES.contains(document.getType())) {
                String title = (String)((Object)document.getPropertyValue("dc:title"));
                String fileName = ToutaticeFileNamingHelper.getDocFileName(document);
                if (StringUtils.isBlank((String)title) && StringUtils.isNotBlank((String)fileName)) {
                    document.setPropertyValue("dc:title", (Serializable)((Object)fileName));
                    ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)document, (boolean)true);
                }
            }
        }
    }
}

