/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.registry;

import fr.toutatice.ecm.es.customizer.listeners.api.ICustomESListener;
import fr.toutatice.ecm.es.customizer.registry.ESListenerDescriptor;
import fr.toutatice.ecm.es.customizer.registry.JsonESWriterDescriptor;
import fr.toutatice.ecm.es.customizer.writers.api.ICustomJsonESWriter;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ESCustomizersServiceRegistry
extends DefaultComponent {
    private static String WRITERS_EXT_POINT = "writers";
    private static String LISTENERS_EXT_POINT = "listeners";
    private List<ICustomJsonESWriter> writers;
    private List<ICustomESListener> listeners;

    public List<ICustomJsonESWriter> getCustomJsonESWriters() {
        return this.writers;
    }

    public List<ICustomESListener> getCustomESListeners() {
        return this.listeners;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.writers = new LinkedList<ICustomJsonESWriter>();
        this.listeners = new LinkedList<ICustomESListener>();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        ESListenerDescriptor desc;
        if (WRITERS_EXT_POINT.equals(extensionPoint)) {
            JsonESWriterDescriptor desc2 = (JsonESWriterDescriptor)contribution;
            if (desc2.isEnabled()) {
                String className = desc2.getClazz();
                ICustomJsonESWriter clazzInstance = (ICustomJsonESWriter)Class.forName(className).newInstance();
                int order = desc2.getOrder();
                this.writers.add(order, clazzInstance);
            }
        } else if (LISTENERS_EXT_POINT.equals(extensionPoint) && (desc = (ESListenerDescriptor)contribution).isEnabled()) {
            String className = desc.getClazz();
            ICustomESListener clazzInstance = (ICustomESListener)Class.forName(className).newInstance();
            int order = desc.getOrder();
            this.listeners.add(order, clazzInstance);
        }
    }
}

