/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.es.customizer.writers.denormalization;

import fr.toutatice.ecm.es.customizer.writers.api.AbstractCustomJsonESWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;

public abstract class AbstractDenormalizationJsonESWriter
extends AbstractCustomJsonESWriter {
    private static final String FIRST_CALL_KEY = "d_first_call";
    private static final String FIRST_CALL_TRUE = "dfc_TRUE";
    private static final String FIRST_CALL_FALSE = "dfc_FALSE";
    private static final String INITIAL_CALLER_KEY = "d_initial_caller";

    protected boolean hasToDenormalize(DocumentModel doc, Map<String, String> contextParameters) {
        if (doc == null) {
            return false;
        }
        boolean callItSelf = false;
        if (contextParameters != null) {
            callItSelf = StringUtils.equals((String)contextParameters.get(INITIAL_CALLER_KEY), (String)doc.getType());
        }
        boolean isNotDeleted = !doc.getLifeCyclePolicy().equalsIgnoreCase("deleted");
        boolean isNotVersion = !doc.isVersion();
        boolean hasToDenormalize = isNotDeleted && isNotVersion && this.accept(doc);
        return hasToDenormalize && !callItSelf;
    }

    @Override
    public void writeData(JsonGenerator jg, DocumentModel doc, String[] schemas, Map<String, String> contextParameters) throws IOException {
        if (this.hasToDenormalize(doc, contextParameters)) {
            contextParameters = this.setCaller(doc, contextParameters);
            this.denormalizeDoc(jg, doc, schemas, contextParameters);
        }
        this.clearCaller(contextParameters);
    }

    private Map<String, String> setCaller(DocumentModel doc, Map<String, String> contextParameters) {
        if (contextParameters == null) {
            contextParameters = new HashMap<String, String>(2);
            contextParameters.put(FIRST_CALL_KEY, FIRST_CALL_TRUE);
        }
        if (StringUtils.equals((String)FIRST_CALL_TRUE, (String)contextParameters.get(FIRST_CALL_KEY))) {
            contextParameters.put(INITIAL_CALLER_KEY, doc.getType());
        }
        contextParameters.put(FIRST_CALL_KEY, FIRST_CALL_FALSE);
        return contextParameters;
    }

    private void clearCaller(Map<String, String> contextParameters) {
        if (contextParameters != null) {
            contextParameters.remove(INITIAL_CALLER_KEY);
            contextParameters.put(FIRST_CALL_KEY, FIRST_CALL_TRUE);
        }
    }

    protected abstract void denormalizeDoc(JsonGenerator var1, DocumentModel var2, String[] var3, Map<String, String> var4) throws IOException;
}

