/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.IPhaseSelectionStrategy;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.core.VarActivityListener;
import org.sat4j.minisat.learning.ClauseOnlyLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.orders.PhaseInLastLearnedClauseSelectionStrategy;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.orders.UserFixedPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.ArminRestarts;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.OPBStringSolver;
import org.sat4j.pb.OptToPBSATAdapter;
import org.sat4j.pb.PseudoOptDecorator;
import org.sat4j.pb.constraints.AbstractPBDataStructureFactory;
import org.sat4j.pb.constraints.CompetMinHTmixedClauseCardConstrDataStructureFactory;
import org.sat4j.pb.constraints.CompetResolutionMinPBLongMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBLongMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBLongMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBMixedHTClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.CompetResolutionPBMixedWLClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBLongMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBLongMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMaxDataStructure;
import org.sat4j.pb.constraints.PBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PBMinDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseAtLeastConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinClauseCardConstrDataStructure;
import org.sat4j.pb.constraints.PuebloPBMinDataStructure;
import org.sat4j.pb.core.PBDataStructureFactory;
import org.sat4j.pb.core.PBSolverCP;
import org.sat4j.pb.core.PBSolverCautious;
import org.sat4j.pb.core.PBSolverClause;
import org.sat4j.pb.core.PBSolverResCP;
import org.sat4j.pb.core.PBSolverResolution;
import org.sat4j.pb.core.PBSolverWithImpliedClause;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.pb.tools.ManyCorePB;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverFactory
extends ASolverFactory<IPBSolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static PBSolverResolution newPBResAllPB() {
        return SolverFactory.newPBRes(new PBMaxDataStructure());
    }

    public static PBSolverCP newPBCPAllPB() {
        return SolverFactory.newPBCP(new PBMaxDataStructure());
    }

    public static IPBSolver newOPBStringSolver() {
        return new OPBStringSolver();
    }

    public static PBSolverCP newPBCPMixedConstraints() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure());
    }

    public static PBSolverCP newPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsObjective() {
        return SolverFactory.newPBCP(new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsMinObjective() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsLongMaxObjective() {
        return SolverFactory.newPBCP(new PBLongMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsLongMinObjective() {
        return SolverFactory.newPBCP(new PBLongMinClauseCardConstrDataStructure(), new VarOrderHeapObjective());
    }

    public static PBSolverCP newPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setSolver((Solver)solver);
        return solver;
    }

    public static PBSolverCP newCompetPBCPMixedConstraintsObjectiveLearnJustClauses() {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setSolver((Solver)solver);
        return solver;
    }

    private static PBSolverCP newPBKiller(IPhaseSelectionStrategy phase) {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(phase));
        learning.setSolver((Solver)solver);
        return solver;
    }

    public static PBSolverCP newPBKillerRSAT() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP newPBKillerClassic() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP newPBKillerFixed() {
        return SolverFactory.newPBKiller((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    private static PBSolverCP newCompetPBKiller(IPhaseSelectionStrategy phase) {
        ClauseOnlyLearning learning = new ClauseOnlyLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(phase));
        learning.setSolver((Solver)solver);
        return solver;
    }

    public static PBSolverCP newCompetPBKillerRSAT() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy());
    }

    public static PBSolverCP newCompetPBKillerClassic() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new PhaseInLastLearnedClauseSelectionStrategy());
    }

    public static PBSolverCP newCompetPBKillerFixed() {
        return SolverFactory.newCompetPBKiller((IPhaseSelectionStrategy)new UserFixedPhaseSelectionStrategy());
    }

    public static PBSolverCP newMiniLearningOPBClauseCardConstrMaxSpecificOrderIncrementalReductionToClause() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverClause solver = new PBSolverClause((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCP newPBCPMixedConstraintsObjectiveNoLearning() {
        NoLearningButHeuristics learning = new NoLearningButHeuristics();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective());
        learning.setSolver((Solver)solver);
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newPBResMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newCompetPBResWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResHTMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBMixedHTClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResLongHTMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBLongMixedHTClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResLongWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionPBLongMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetMinPBResLongWLMixedConstraintsObjectiveExpSimp() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp(new CompetResolutionMinPBLongMixedWLClauseCardConstrDataStructure());
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp(PBDataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, dsf, new VarOrderHeapObjective((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy()), (RestartStrategy)new ArminRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newPBResHTMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        CompetResolutionPBMixedHTClauseCardConstrDataStructure ds = new CompetResolutionPBMixedHTClauseCardConstrDataStructure();
        ds.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, ds, new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newCompetPBResMinHTMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, new CompetMinHTmixedClauseCardConstrDataStructureFactory(), new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newPBResMinHTMixedConstraintsObjective() {
        MiniSATLearning learning = new MiniSATLearning();
        CompetMinHTmixedClauseCardConstrDataStructureFactory ds = new CompetMinHTmixedClauseCardConstrDataStructureFactory();
        ds.setNormalizer(AbstractPBDataStructureFactory.NO_COMPETITION);
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, ds, new VarOrderHeapObjective(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverResolution newCompetPBResMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution solver = SolverFactory.newPBResMixedConstraintsObjective();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newPBResHTMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution solver = SolverFactory.newPBResHTMixedConstraintsObjective();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newCompetPBResMinHTMixedConstraintsObjectiveExpSimp() {
        PBSolverResolution solver = SolverFactory.newCompetPBResMinHTMixedConstraintsObjective();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverClause newPBCPMixedConstraintsReduceToClause() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverClause solver = new PBSolverClause((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCautious newPBCPMixedConstraintsCautious(int bound) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCautious solver = new PBSolverCautious((LearningStrategy<PBDataStructureFactory>)learning, (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), bound);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCautious newPBCPMixedConstraintsCautious() {
        return SolverFactory.newPBCPMixedConstraintsCautious(10);
    }

    public static PBSolverResCP newPBCPMixedConstraintsResCP(long bound) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResCP solver = new PBSolverResCP((LearningStrategy<PBDataStructureFactory>)learning, (PBDataStructureFactory)new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeapObjective(), bound);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResCP newPBCPMixedConstraintsResCP() {
        return SolverFactory.newPBCPMixedConstraintsResCP(100000L);
    }

    public static PBSolverWithImpliedClause newPBCPMixedConstrainsImplied() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverWithImpliedClause solver = new PBSolverWithImpliedClause((LearningStrategy<PBDataStructureFactory>)learning, new PBMaxClauseCardConstrDataStructure(), (IOrder)new VarOrderHeap());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCP newMiniOPBClauseAtLeastConstrMax() {
        return SolverFactory.newPBCP(new PBMaxClauseAtLeastConstrDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWL() {
        return SolverFactory.newPBRes(new PBMinDataStructure());
    }

    public static PBSolverCP newPBCPAllPBWL() {
        return SolverFactory.newPBCP(new PBMinDataStructure());
    }

    public static PBSolverResolution newPBResAllPBWLPueblo() {
        return SolverFactory.newPBRes(new PuebloPBMinDataStructure());
    }

    private static PBSolverResolution newPBRes(PBDataStructureFactory dsf) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, dsf, (IOrder)new VarOrderHeap(), (RestartStrategy)new MiniSATRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        return solver;
    }

    public static PBSolverCP newPBCPAllPBWLPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseCardMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseCardMin() {
        return SolverFactory.newPBCP(new PBMinClauseCardConstrDataStructure());
    }

    public static PBSolverCP newMiniOPBClauseAtLeastMinPueblo() {
        return SolverFactory.newPBCP(new PuebloPBMinClauseAtLeastConstrDataStructure());
    }

    private static PBSolverCP newPBCP(PBDataStructureFactory dsf, IOrder order) {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverCP solver = new PBSolverCP((LearningStrategy<PBDataStructureFactory>)learning, dsf, order);
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setRestartStrategy((RestartStrategy)new ArminRestarts());
        solver.setLearnedConstraintsDeletionStrategy(solver.glucose);
        return solver;
    }

    private static PBSolverCP newPBCP(PBDataStructureFactory dsf) {
        return SolverFactory.newPBCP(dsf, (IOrder)new VarOrderHeap());
    }

    public static IPBSolver newCuttingPlanes() {
        return SolverFactory.newCompetPBCPMixedConstraintsObjective();
    }

    public static IPBSolver newCuttingPlanesAggressiveCleanup() {
        PBSolverCP solver = SolverFactory.newCompetPBCPMixedConstraintsObjective();
        solver.setLearnedConstraintsDeletionStrategy(solver.fixedSize(100));
        return solver;
    }

    public static IPBSolver newResolution() {
        return SolverFactory.newResolutionGlucoseExpSimp();
    }

    public static IPBSolver newBoth() {
        return new ManyCorePB(new IPBSolver[]{SolverFactory.newResolution(), SolverFactory.newCuttingPlanes()});
    }

    public static PBSolverResolution newResolutionGlucose() {
        PBSolverResolution solver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        solver.setSimplifier(Solver.NO_SIMPLIFICATION);
        solver.setLearnedConstraintsDeletionStrategy(solver.glucose);
        return solver;
    }

    public static PBSolverResolution newResolutionGlucoseSimpleSimp() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static PBSolverResolution newResolutionGlucoseExpSimp() {
        PBSolverResolution solver = SolverFactory.newResolutionGlucose();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static IPBSolver newSimpleSimplification() {
        PBSolverResolution solver = SolverFactory.newCompetPBResWLMixedConstraintsObjectiveExpSimp();
        solver.setLearnedConstraintsDeletionStrategy(solver.glucose);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static IPBSolver newResolutionSimpleRestarts() {
        PBSolverResolution solver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        solver.setLearnedConstraintsDeletionStrategy(solver.glucose);
        solver.setRestartStrategy((RestartStrategy)new MiniSATRestarts());
        return solver;
    }

    public static IPBSolver newResolutionMaxMemory() {
        PBSolverResolution solver = SolverFactory.newCompetPBResLongWLMixedConstraintsObjectiveExpSimp();
        solver.setLearnedConstraintsDeletionStrategy(solver.memory_based);
        return solver;
    }

    public static IPBSolver newDefault() {
        return SolverFactory.newResolutionGlucose();
    }

    public static IPBSolver newDefaultNonNormalized() {
        return SolverFactory.newPBResHTMixedConstraintsObjectiveExpSimp();
    }

    public IPBSolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static IPBSolver newLight() {
        return SolverFactory.newCompetPBResMixedConstraintsObjectiveExpSimp();
    }

    public IPBSolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }

    public static IPBSolver newEclipseP2() {
        MiniSATLearning learning = new MiniSATLearning();
        PBSolverResolution solver = new PBSolverResolution((LearningStrategy<PBDataStructureFactory>)learning, new CompetResolutionPBMixedHTClauseCardConstrDataStructure(), new VarOrderHeapObjective((IPhaseSelectionStrategy)new RSATPhaseSelectionStrategy()), (RestartStrategy)new ArminRestarts());
        learning.setDataStructureFactory(solver.getDSFactory());
        learning.setVarActivityListener((VarActivityListener)solver);
        solver.setTimeoutOnConflicts(300);
        solver.setVerbose(false);
        return new OptToPBSATAdapter(new PseudoOptDecorator(solver));
    }
}

