/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jms;

import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.jms.TopicSession;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.EVENT)
@BypassInterceptors
@Install(value=false)
public class ManagedTopicPublisher {
    private String topicJndiName;
    private TopicPublisher topicPublisher;

    public String getTopicJndiName() {
        return this.topicJndiName;
    }

    public void setTopicJndiName(String jndiName) {
        this.topicJndiName = jndiName;
    }

    public Topic getTopic() throws NamingException {
        return (Topic)Naming.getInitialContext().lookup(this.topicJndiName);
    }

    @Create
    public void create() throws JMSException, NamingException {
        this.topicPublisher = TopicSession.instance().createPublisher(this.getTopic());
    }

    @Destroy
    public void destroy() throws JMSException {
        this.topicPublisher.close();
    }

    @Unwrap
    public TopicPublisher getTopicPublisher() {
        return this.topicPublisher;
    }

    public String toString() {
        return "TopicConnection(" + this.topicJndiName + ")";
    }
}

