/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.util.DateUtils;
import org.restlet.util.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Template {
    public static final int MODE_STARTS_WITH = 1;
    public static final int MODE_EQUALS = 2;
    private String pattern;
    private Variable defaultVariable;
    private Logger logger;
    private int matchingMode;
    private Map<String, Variable> variables;
    private Pattern regexPattern;
    private List<String> regexVariables;

    private static boolean isAlpha(int character) {
        return Template.isUpperCase(character) || Template.isLowerCase(character);
    }

    private static boolean isDigit(int character) {
        return character >= 48 && character <= 57;
    }

    private static boolean isLowerCase(int character) {
        return character >= 97 && character <= 122;
    }

    private static boolean isUnreserved(int character) {
        return Template.isAlpha(character) || Template.isDigit(character) || character == 45 || character == 46 || character == 95 || character == 126;
    }

    private static boolean isUpperCase(int character) {
        return character >= 65 && character <= 90;
    }

    public Template(Logger logger, String pattern) {
        this(logger, pattern, 2, 1, "", true, false);
    }

    public Template(Logger logger, String pattern, int matchingMode) {
        this(logger, pattern, matchingMode, 1, "", true, false);
    }

    public Template(Logger logger, String pattern, int matchingMode, int defaultType, String defaultDefaultValue, boolean defaultRequired, boolean defaultFixed) {
        this.logger = logger;
        this.pattern = pattern;
        this.defaultVariable = new Variable(defaultType, defaultDefaultValue, defaultRequired, defaultFixed);
        this.matchingMode = matchingMode;
        this.variables = new TreeMap<String, Variable>();
        this.regexPattern = null;
        this.regexVariables = null;
    }

    public String format(Request request, Response response) {
        return this.format(new CallVariableResolver(request, response));
    }

    public String format(Map<String, Object> variables) {
        return this.format(new MapVariableResolver(variables));
    }

    private String format(VariableResolver resolver) {
        StringBuilder result = new StringBuilder();
        StringBuilder varBuffer = null;
        boolean inVariable = false;
        for (int i = 0; i < this.getPattern().length(); ++i) {
            char next = this.getPattern().charAt(i);
            if (inVariable) {
                if (Template.isUnreserved(next)) {
                    varBuffer.append(next);
                    continue;
                }
                if (next == '}') {
                    if (varBuffer.length() == 0) {
                        this.getLogger().warning("Empty pattern variables are not allowed : " + this.regexPattern);
                    } else {
                        String varName = varBuffer.toString();
                        result.append(resolver.resolve(varName));
                        varBuffer = new StringBuilder();
                    }
                    inVariable = false;
                    continue;
                }
                this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                continue;
            }
            if (next == '{') {
                inVariable = true;
                varBuffer = new StringBuilder();
                continue;
            }
            if (next == '}') {
                this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                continue;
            }
            result.append(next);
        }
        return result.toString();
    }

    public Variable getDefaultVariable() {
        return this.defaultVariable;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getMatchingMode() {
        return this.matchingMode;
    }

    public String getPattern() {
        return this.pattern;
    }

    private Pattern getRegexPattern() {
        if (this.regexPattern == null) {
            StringBuilder patternBuffer = new StringBuilder();
            StringBuilder varBuffer = null;
            boolean inVariable = false;
            for (int i = 0; i < this.getPattern().length(); ++i) {
                char next = this.getPattern().charAt(i);
                if (inVariable) {
                    if (Template.isUnreserved(next)) {
                        varBuffer.append(next);
                        continue;
                    }
                    if (next == '}') {
                        if (varBuffer.length() == 0) {
                            this.getLogger().warning("Empty pattern variables are not allowed : " + this.regexPattern);
                        } else {
                            String varName = varBuffer.toString();
                            int varIndex = this.getRegexVariables().indexOf(varName);
                            if (varIndex != -1) {
                                patternBuffer.append("\\" + (varIndex + 1));
                            } else {
                                this.getRegexVariables().add(varName);
                                Variable var = this.getVariables().get(varName);
                                if (var == null) {
                                    var = this.getDefaultVariable();
                                }
                                patternBuffer.append(this.getVariableRegex(var));
                            }
                            varBuffer = new StringBuilder();
                        }
                        inVariable = false;
                        continue;
                    }
                    this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                    continue;
                }
                if (next == '{') {
                    inVariable = true;
                    varBuffer = new StringBuilder();
                    continue;
                }
                if (next == '}') {
                    this.getLogger().warning("An invalid character was detected inside a pattern variable : " + this.regexPattern);
                    continue;
                }
                patternBuffer.append(this.quote(next));
            }
            this.regexPattern = Pattern.compile(patternBuffer.toString());
        }
        return this.regexPattern;
    }

    private String quote(char character) {
        switch (character) {
            case '[': {
                return "\\[";
            }
            case ']': {
                return "\\]";
            }
            case '.': {
                return "\\.";
            }
            case '\\': {
                return "\\\\";
            }
            case '$': {
                return "\\$";
            }
            case '^': {
                return "\\^";
            }
            case '?': {
                return "\\?";
            }
            case '*': {
                return "\\*";
            }
            case '|': {
                return "\\|";
            }
            case '(': {
                return "\\(";
            }
            case ')': {
                return "\\)";
            }
            case ':': {
                return "\\:";
            }
            case '-': {
                return "\\-";
            }
            case '!': {
                return "\\!";
            }
            case '<': {
                return "\\<";
            }
            case '>': {
                return "\\>";
            }
        }
        return Character.toString(character);
    }

    private List<String> getRegexVariables() {
        if (this.regexVariables == null) {
            this.regexVariables = new ArrayList<String>();
        }
        return this.regexVariables;
    }

    private String getReferenceContent(String partName, Reference reference) {
        String result = null;
        if (reference != null) {
            if (partName.equals("a")) {
                result = reference.getAuthority();
            } else if (partName.startsWith("b")) {
                result = this.getReferenceContent(partName.substring(1), reference.getBaseRef());
            } else if (partName.equals("e")) {
                result = reference.getRelativePart();
            } else if (partName.equals("f")) {
                result = reference.getFragment();
            } else if (partName.equals("h")) {
                result = reference.getHostIdentifier();
            } else if (partName.equals("i")) {
                result = reference.getIdentifier();
            } else if (partName.equals("p")) {
                result = reference.getPath();
            } else if (partName.equals("q")) {
                result = reference.getQuery();
            } else if (partName.equals("r")) {
                result = reference.getRemainingPart();
            }
        }
        return result;
    }

    private String getVariableRegex(Variable variable) {
        String result = null;
        if (variable.isFixed()) {
            result = Pattern.quote(variable.getDefaultValue());
        } else {
            String ALL = ".";
            String ALPHA = "a-zA-Z";
            String DIGIT = "0-9";
            String ALPHA_DIGIT = "a-zA-Z0-9";
            String HEXA = "0-9ABCDEFabcdef";
            String URI_UNRESERVED = "a-zA-Z0-9\\-\\.\\_\\~";
            String URI_GEN_DELIMS = "\\:\\/\\?\\#\\[\\]\\@";
            String URI_SUB_DELIMS = "\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=";
            String URI_RESERVED = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=";
            String URI_ALL = "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=a-zA-Z0-9\\-\\.\\_\\~";
            String WORD = "\\w";
            String PCT_ENCODED = "\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef]";
            String PCHAR = "[a-zA-Z0-9\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef])";
            String QUERY = "[a-zA-Z0-9\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef])|\\/|\\?";
            String FRAGMENT = "[a-zA-Z0-9\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef])|\\/|\\?";
            StringBuilder coreRegex = new StringBuilder();
            switch (variable.getType()) {
                case 1: {
                    this.appendClass(coreRegex, ".", variable.isRequired());
                    break;
                }
                case 2: {
                    this.appendClass(coreRegex, "a-zA-Z", variable.isRequired());
                    break;
                }
                case 4: {
                    this.appendClass(coreRegex, "0-9", variable.isRequired());
                    break;
                }
                case 3: {
                    this.appendClass(coreRegex, "a-zA-Z0-9", variable.isRequired());
                    break;
                }
                case 5: {
                    this.appendClass(coreRegex, "\\:\\/\\?\\#\\[\\]\\@\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=a-zA-Z0-9\\-\\.\\_\\~", variable.isRequired());
                    break;
                }
                case 10: {
                    this.appendClass(coreRegex, "a-zA-Z0-9\\-\\.\\_\\~", variable.isRequired());
                    break;
                }
                case 11: {
                    this.appendClass(coreRegex, "\\w", variable.isRequired());
                    break;
                }
                case 6: {
                    this.appendGroup(coreRegex, "[a-zA-Z0-9\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef])|\\/|\\?", variable.isRequired());
                    break;
                }
                case 7: {
                    this.appendGroup(coreRegex, "[a-zA-Z0-9\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef])|\\/|\\?", variable.isRequired());
                    break;
                }
                case 9: {
                    this.appendGroup(coreRegex, "[a-zA-Z0-9\\-\\.\\_\\~\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=\\:\\@]|(?:\\%[0-9ABCDEFabcdef][0-9ABCDEFabcdef])", variable.isRequired());
                }
            }
            result = coreRegex.toString();
        }
        return result;
    }

    private void appendClass(StringBuilder pattern, String content, boolean required) {
        pattern.append("(");
        if (content.equals(".")) {
            pattern.append(content);
        } else {
            pattern.append("[").append(content).append(']');
        }
        if (required) {
            pattern.append("+");
        } else {
            pattern.append("*");
        }
        pattern.append(")");
    }

    private void appendGroup(StringBuilder pattern, String content, boolean required) {
        pattern.append("((?:").append(content).append(')');
        if (required) {
            pattern.append("+");
        } else {
            pattern.append("*");
        }
        pattern.append(")");
    }

    public Map<String, Variable> getVariables() {
        return this.variables;
    }

    public int match(String formattedString) {
        int result = -1;
        try {
            if (formattedString != null) {
                Matcher matcher = this.getRegexPattern().matcher(formattedString);
                if (this.getMatchingMode() == 2 && matcher.matches()) {
                    result = matcher.end();
                } else if (this.getMatchingMode() == 1 && matcher.lookingAt()) {
                    result = matcher.end();
                }
            }
        }
        catch (StackOverflowError soe) {
            this.getLogger().warning("StackOverflowError exception encountered while matching this string : " + formattedString);
        }
        return result;
    }

    public int parse(String formattedString, Request request) {
        return this.parse(formattedString, request.getAttributes());
    }

    public int parse(String formattedString, Map<String, Object> variables) {
        int result = -1;
        try {
            boolean matched;
            Matcher matcher = this.getRegexPattern().matcher(formattedString);
            boolean bl = matched = this.getMatchingMode() == 2 && matcher.matches() || this.getMatchingMode() == 1 && matcher.lookingAt();
            if (matched) {
                result = matcher.end();
                String attributeName = null;
                String attributeValue = null;
                for (int i = 0; i < this.getRegexVariables().size(); ++i) {
                    attributeName = this.getRegexVariables().get(i);
                    attributeValue = matcher.group(i + 1);
                    variables.put(attributeName, attributeValue);
                }
            }
        }
        catch (StackOverflowError soe) {
            this.getLogger().warning("StackOverflowError exception encountered while matching this string : " + formattedString);
        }
        return result;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setMatchingMode(int matchingMode) {
        this.matchingMode = matchingMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MapVariableResolver
    extends VariableResolver {
        private Map<String, Object> map;

        public MapVariableResolver(Map<String, Object> map) {
            this.map = map;
        }

        @Override
        public String resolve(String variableName) {
            Object value = this.map.get(variableName);
            return value == null ? null : value.toString();
        }
    }

    private class CallVariableResolver
    extends VariableResolver {
        private Request request;
        private Response response;

        public CallVariableResolver(Request request, Response response) {
            this.request = request;
            this.response = response;
        }

        public String resolve(String variableName) {
            Object variable;
            String result = null;
            Variable var = Template.this.getVariables().get(variableName);
            if (var == null) {
                var = Template.this.getDefaultVariable();
            }
            if (this.request != null && (variable = this.request.getAttributes().get(variableName)) != null) {
                result = variable.toString();
            }
            if (result == null && this.response != null && this.response.getAttributes().containsKey(variableName)) {
                result = this.response.getAttributes().get(variableName).toString();
            }
            if (result == null) {
                int i;
                StringBuilder value;
                if (this.request != null) {
                    if (variableName.equals("c")) {
                        result = Boolean.toString(this.request.isConfidential());
                    } else if (variableName.equals("cia")) {
                        result = this.request.getClientInfo().getAddress();
                    } else if (variableName.equals("cig")) {
                        result = this.request.getClientInfo().getAgent();
                    } else if (variableName.equals("cri")) {
                        result = this.request.getChallengeResponse().getIdentifier();
                    } else if (variableName.equals("crs")) {
                        if (this.request.getChallengeResponse().getScheme() != null) {
                            result = this.request.getChallengeResponse().getScheme().getTechnicalName();
                        }
                    } else if (variableName.equals("ecs")) {
                        if (this.request.getEntity() != null && this.request.getEntity().getCharacterSet() != null) {
                            result = this.request.getEntity().getCharacterSet().getName();
                        }
                    } else if (variableName.equals("ee")) {
                        if (this.request.getEntity() != null && !this.request.getEntity().getEncodings().isEmpty()) {
                            value = new StringBuilder();
                            for (i = 0; i < this.request.getEntity().getEncodings().size(); ++i) {
                                if (i > 0) {
                                    value.append(", ");
                                }
                                value.append(this.request.getEntity().getEncodings().get(i).getName());
                            }
                            result = value.toString();
                        }
                    } else if (variableName.equals("eed")) {
                        if (this.request.getEntity() != null && this.request.getEntity().getExpirationDate() != null) {
                            result = DateUtils.format(this.request.getEntity().getExpirationDate(), DateUtils.FORMAT_RFC_1123.get(0));
                        }
                    } else if (variableName.equals("el")) {
                        if (this.request.getEntity() != null && !this.request.getEntity().getLanguages().isEmpty()) {
                            value = new StringBuilder();
                            for (i = 0; i < this.request.getEntity().getLanguages().size(); ++i) {
                                if (i > 0) {
                                    value.append(", ");
                                }
                                value.append(this.request.getEntity().getLanguages().get(i).getName());
                            }
                            result = value.toString();
                        }
                    } else if (variableName.equals("emd")) {
                        if (this.request.getEntity() != null && this.request.getEntity().getModificationDate() != null) {
                            result = DateUtils.format(this.request.getEntity().getModificationDate(), DateUtils.FORMAT_RFC_1123.get(0));
                        }
                    } else if (variableName.equals("emt")) {
                        if (this.request.getEntity() != null && this.request.getEntity().getMediaType() != null) {
                            result = this.request.getEntity().getMediaType().getName();
                        }
                    } else if (variableName.equals("es")) {
                        if (this.request.getEntity() != null && this.request.getEntity().getSize() != -1L) {
                            result = Long.toString(this.request.getEntity().getSize());
                        }
                    } else if (variableName.equals("et")) {
                        if (this.request.getEntity() != null && this.request.getEntity().getTag() != null) {
                            result = this.request.getEntity().getTag().getName();
                        }
                    } else if (variableName.startsWith("f")) {
                        result = Template.this.getReferenceContent(variableName.substring(1), this.request.getReferrerRef());
                    } else if (variableName.startsWith("h")) {
                        result = Template.this.getReferenceContent(variableName.substring(1), this.request.getHostRef());
                    } else if (variableName.equals("m")) {
                        if (this.request.getMethod() != null) {
                            result = this.request.getMethod().getName();
                        }
                    } else if (variableName.startsWith("o")) {
                        result = Template.this.getReferenceContent(variableName.substring(1), this.request.getRootRef());
                    } else if (variableName.equals("p")) {
                        if (this.request.getProtocol() != null) {
                            result = this.request.getProtocol().getName();
                        }
                    } else if (variableName.startsWith("r")) {
                        result = Template.this.getReferenceContent(variableName.substring(1), this.request.getResourceRef());
                    }
                }
                if (result == null && this.response != null) {
                    if (variableName.equals("ECS")) {
                        if (this.response.getEntity() != null && this.response.getEntity().getCharacterSet() != null) {
                            result = this.response.getEntity().getCharacterSet().getName();
                        }
                    } else if (variableName.equals("EE")) {
                        if (this.response.getEntity() != null && !this.response.getEntity().getEncodings().isEmpty()) {
                            value = new StringBuilder();
                            for (i = 0; i < this.response.getEntity().getEncodings().size(); ++i) {
                                if (i > 0) {
                                    value.append(", ");
                                }
                                value.append(this.response.getEntity().getEncodings().get(i).getName());
                            }
                            result = value.toString();
                        }
                    } else if (variableName.equals("EED")) {
                        if (this.response.getEntity() != null && this.response.getEntity().getExpirationDate() != null) {
                            result = DateUtils.format(this.response.getEntity().getExpirationDate(), DateUtils.FORMAT_RFC_1123.get(0));
                        }
                    } else if (variableName.equals("EL")) {
                        if (this.response.getEntity() != null && !this.response.getEntity().getLanguages().isEmpty()) {
                            value = new StringBuilder();
                            for (i = 0; i < this.response.getEntity().getLanguages().size(); ++i) {
                                if (i > 0) {
                                    value.append(", ");
                                }
                                value.append(this.response.getEntity().getLanguages().get(i).getName());
                            }
                            result = value.toString();
                        }
                    } else if (variableName.equals("EMD")) {
                        if (this.response.getEntity() != null && this.response.getEntity().getModificationDate() != null) {
                            result = DateUtils.format(this.response.getEntity().getModificationDate(), DateUtils.FORMAT_RFC_1123.get(0));
                        }
                    } else if (variableName.equals("EMT")) {
                        if (this.response.getEntity() != null && this.response.getEntity().getMediaType() != null) {
                            result = this.response.getEntity().getMediaType().getName();
                        }
                    } else if (variableName.equals("ES")) {
                        if (this.response.getEntity() != null && this.response.getEntity().getSize() != -1L) {
                            result = Long.toString(this.response.getEntity().getSize());
                        }
                    } else if (variableName.equals("ET")) {
                        if (this.response.getEntity() != null && this.response.getEntity().getTag() != null) {
                            result = this.response.getEntity().getTag().getName();
                        }
                    } else if (variableName.startsWith("R")) {
                        result = Template.this.getReferenceContent(variableName.substring(1), this.response.getRedirectRef());
                    } else if (variableName.equals("S")) {
                        if (this.response.getStatus() != null) {
                            result = Integer.toString(this.response.getStatus().getCode());
                        }
                    } else if (variableName.equals("SIA")) {
                        result = this.response.getServerInfo().getAddress();
                    } else if (variableName.equals("SIG")) {
                        result = this.response.getServerInfo().getAgent();
                    } else if (variableName.equals("SIP") && this.response.getServerInfo().getPort() != -1) {
                        result = Integer.toString(this.response.getServerInfo().getPort());
                    }
                }
            }
            if (result == null) {
                result = var.getDefaultValue();
            }
            return result;
        }
    }

    private abstract class VariableResolver {
        private VariableResolver() {
        }

        public abstract String resolve(String var1);
    }
}

