/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.List;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectoryFactory;
import org.nuxeo.runtime.api.Framework;

public class DirectoryFactoryProxy
implements DirectoryFactory {
    private DirectoryFactory factory;
    private final String componentName;

    public DirectoryFactoryProxy(String componentName) {
        this.componentName = componentName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    private DirectoryFactory getRealObject() {
        if (this.factory == null) {
            this.factory = (DirectoryFactory)Framework.getRuntime().getComponent(this.componentName);
        }
        if (this.factory == null) {
            throw new RuntimeException(String.format("No Runtime component found for directory factory '%s'", this.componentName));
        }
        return this.factory;
    }

    public Directory getDirectory(String name) throws DirectoryException {
        return this.getRealObject().getDirectory(name);
    }

    public String getName() {
        return this.getRealObject().getName();
    }

    public void shutdown() throws DirectoryException {
        if (this.factory != null) {
            this.factory.shutdown();
            this.factory = null;
        }
    }

    public List<Directory> getDirectories() throws DirectoryException {
        return this.getRealObject().getDirectories();
    }
}

