/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.jaxrs.io.usermanager;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.EntityWriter;
import org.nuxeo.ecm.automation.jaxrs.io.documents.JsonDocumentWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Provider
@Produces(value={"application/json+nxentity", "application/json"})
public class NuxeoPrincipalWriter
extends EntityWriter<NuxeoPrincipal> {
    public static final String ENTITY_TYPE = "user";
    @Context
    JsonFactory factory;

    public void writeEntityBody(JsonGenerator jg, NuxeoPrincipal principal) throws JsonGenerationException, IOException, ClientException {
        jg.writeStringField("id", principal.getName());
        NuxeoPrincipalWriter.writeProperties(jg, principal.getModel());
        NuxeoPrincipalWriter.writeExtendedGroups(jg, principal.getAllGroups());
        jg.writeBooleanField("isAdministrator", principal.isAdministrator());
        jg.writeBooleanField("isAnonymous", principal.isAnonymous());
    }

    private static void writeProperties(JsonGenerator jg, DocumentModel doc) throws JsonGenerationException, IOException, ClientException {
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        jg.writeFieldName("properties");
        jg.writeStartObject();
        DocumentPart part = doc.getPart(um.getUserSchemaName());
        if (part == null) {
            return;
        }
        for (Property p : part.getChildren()) {
            String fieldName = p.getField().getName().getLocalName();
            jg.writeFieldName(fieldName);
            if (!fieldName.equals(NuxeoPrincipalWriter.getPasswordField(um))) {
                JsonDocumentWriter.writePropertyValue((JsonGenerator)jg, (Property)p, (String)"");
                continue;
            }
            jg.writeString("");
        }
        jg.writeEndObject();
    }

    private static String getPasswordField(UserManager um) throws ClientException {
        String userDirectoryName = um.getUserDirectoryName();
        DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        return dirService.getDirectory(userDirectoryName).getPasswordField();
    }

    private static void writeExtendedGroups(JsonGenerator jg, List<String> allGroups) throws JsonGenerationException, IOException, ClientException {
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        jg.writeArrayFieldStart("extendedGroups");
        for (String strGroup : allGroups) {
            NuxeoGroup group = um.getGroup(strGroup);
            String label = group == null ? strGroup : group.getLabel();
            jg.writeStartObject();
            jg.writeStringField("name", strGroup);
            jg.writeStringField("label", label);
            jg.writeStringField("url", "group/" + strGroup);
            jg.writeEndObject();
        }
        jg.writeEndArray();
    }

    protected String getEntityType() {
        return ENTITY_TYPE;
    }
}

