/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.setup;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.validator.ValidatorException;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.launcher.commons.DatabaseDriverException;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;

@Scope(value=ScopeType.SESSION)
@Name(value="setupWizardAction")
public class SetupWizardActionBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(SetupWizardActionBean.class);
    private static final String[] managedKeyParameters = new String[]{"nuxeo.bind.address", "nuxeo.url", "nuxeo.data.dir", "nuxeo.log.dir", "org.nuxeo.ecm.product.name", "org.nuxeo.ecm.product.version", "nuxeo.conf", "nuxeo.dbtemplate", "nuxeo.db.name", "nuxeo.db.user", "nuxeo.db.password", "nuxeo.db.host", "nuxeo.db.port", "nuxeo.db.min-pool-size", "nuxeo.db.min-pool-size", "nuxeo.db.max-pool-size", "nuxeo.vcs.min-pool-size", "nuxeo.vcs.max-pool-size", "nuxeo.notification.eMailSubjectPrefix", "mailservice.user", "mailservice.password", "mail.store.protocol", "mail.transport.protocol", "mail.store.host", "mail.store.port", "mail.store.user", "mail.store.password", "mail.debug", "mail.transport.host", "mail.transport.port", "mail.transport.auth", "mail.transport.user", "mail.transport.password", "mail.from", "mail.user", "mail.transport.usetls", "nuxeo.http.proxy.host", "nuxeo.http.proxy.port", "nuxeo.http.proxy.login", "nuxeo.http.proxy.password", "org.nuxeo.dev", "nuxeo.directory.type", "nuxeo.user.group.storage", "nuxeo.ldap.url", "nuxeo.ldap.binddn", "nuxeo.ldap.bindpassword", "nuxeo.ldap.retries", "nuxeo.ldap.user.searchBaseDn", "nuxeo.ldap.user.searchClass", "nuxeo.ldap.user.searchFilter", "nuxeo.ldap.user.searchScope", "nuxeo.ldap.user.readonly", "nuxeo.ldap.user.mapping.rdn", "nuxeo.ldap.user.mapping.username", "nuxeo.ldap.user.mapping.password", "nuxeo.ldap.user.mapping.firstname", "nuxeo.ldap.user.mapping.lastname", "nuxeo.ldap.user.mapping.email", "nuxeo.ldap.user.mapping.company", "nuxeo.ldap.group.searchBaseDn", "nuxeo.ldap.group.searchFilter", "nuxeo.ldap.group.searchScope", "nuxeo.ldap.group.readonly", "nuxeo.ldap.group.mapping.rdn", "nuxeo.ldap.group.mapping.name", "nuxeo.ldap.group.mapping.label", "nuxeo.ldap.group.mapping.members.staticAttributeId", "nuxeo.ldap.group.mapping.members.dynamicAttributeId", "nuxeo.ldap.defaultAdministratorId", "nuxeo.ldap.defaultMembersGroup", "nuxeo.user.anonymous.enable", "nuxeo.user.emergency.enable", "nuxeo.user.emergency.username", "nuxeo.user.emergency.password", "nuxeo.user.emergency.firstname", "nuxeo.user.emergency.lastname"};
    protected Map<String, String> parameters;
    protected Map<String, String> advancedParameters;
    protected static final String PROXY_NONE = "none";
    protected static final String PROXY_ANONYMOUS = "anonymous";
    protected static final String PROXY_AUTHENTICATED = "authenticated";
    protected static final String DIRECTORY_DEFAULT = "default";
    protected static final String DIRECTORY_LDAP = "ldap";
    protected static final String DIRECTORY_MULTI = "multi";
    private static final String ERROR_DB_DRIVER = "error.db.driver.notfound";
    private static final String ERROR_DB_CONNECTION = "error.db.connection";
    private static final String ERROR_LDAP_CONNECTION = "error.ldap.connection";
    private static final String ERROR_LDAP_AUTHENTICATION = "error.ldap.authentication";
    private static final String ERROR_DB_FS = "error.db.fs";
    protected String proxyType = "none";
    protected String directoryType = "default";
    protected boolean needsRestart = false;
    @In(create=true)
    private transient ConfigurationGenerator setupConfigGenerator;
    protected Properties userConfig;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    private Boolean needGroupConfiguration;

    @Factory(value="setupRequiresRestart", scope=ScopeType.EVENT)
    public boolean isNeedsRestart() {
        return this.needsRestart;
    }

    public void setNeedsRestart(boolean needsRestart) {
        this.needsRestart = needsRestart;
    }

    @Factory(value="setupConfigGenerator", scope=ScopeType.PAGE)
    public ConfigurationGenerator getConfigurationGenerator() {
        if (this.setupConfigGenerator == null) {
            this.setupConfigGenerator = new ConfigurationGenerator();
            if (this.setupConfigGenerator.init()) {
                this.setParameters();
            }
        }
        return this.setupConfigGenerator;
    }

    @Factory(value="setupConfigurable", scope=ScopeType.APPLICATION)
    public boolean isConfigurable() {
        return this.setupConfigGenerator.isConfigurable();
    }

    @Factory(value="advancedParams", scope=ScopeType.EVENT)
    public Map<String, String> getAdvancedParameters() {
        return this.advancedParameters;
    }

    @Factory(value="setupParams", scope=ScopeType.EVENT)
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    protected void setParameters() {
        this.userConfig = this.setupConfigGenerator.getUserConfig();
        this.parameters = new HashMap<String, String>();
        this.advancedParameters = new TreeMap<String, String>();
        for (String key : this.userConfig.stringPropertyNames()) {
            if (System.getProperty(key) != null && !key.matches("^(nuxeo|org\\.nuxeo|catalina|derby|h2|java\\.home|java\\.io\\.tmpdir|tomcat|sun\\.rmi\\.dgc).*")) continue;
            this.advancedParameters.put(key, this.userConfig.getProperty(key).trim());
        }
        for (String keyParam : managedKeyParameters) {
            String parameter = this.userConfig.getProperty(keyParam);
            this.setParameter(keyParam, parameter);
        }
        this.proxyType = PROXY_NONE;
        if (this.parameters.get("nuxeo.http.proxy.host") != null) {
            this.proxyType = PROXY_ANONYMOUS;
            if (this.parameters.get("nuxeo.http.proxy.login") != null) {
                this.proxyType = PROXY_AUTHENTICATED;
            }
        }
        if (this.parameters.get("nuxeo.directory.type") != null) {
            this.directoryType = this.parameters.get("nuxeo.directory.type");
        }
    }

    private void setParameter(String key, String value) {
        if (value != null) {
            this.parameters.put(key, value.trim());
            this.advancedParameters.remove(key);
        }
    }

    public void save() {
        this.saveParameters();
        this.setNeedsRestart(true);
        this.resetParameters();
        this.getConfigurationGenerator();
        this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("label.parameters.saved"), new Object[0]);
    }

    protected void saveParameters() {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (entry.getValue() instanceof Long) {
                entry.setValue(((Long)((Object)entry.getValue())).toString());
            }
            if (entry.getValue() instanceof Boolean) {
                entry.setValue(((Boolean)((Object)entry.getValue())).toString());
            }
            if (!(entry.getValue() instanceof BigDecimal)) continue;
            entry.setValue(entry.getValue().toString());
        }
        if (!PROXY_AUTHENTICATED.equals(this.proxyType)) {
            this.parameters.put("nuxeo.http.proxy.login", "");
            this.parameters.put("nuxeo.http.proxy.password", "");
        }
        if (PROXY_NONE.equals(this.proxyType)) {
            this.parameters.put("nuxeo.http.proxy.host", "");
            this.parameters.put("nuxeo.http.proxy.port", "");
        }
        for (String pwdKey : new String[]{"nuxeo.db.password", "mailservice.password", "mail.transport.password", "nuxeo.http.proxy.password"}) {
            if (!StringUtils.isEmpty((String)this.parameters.get(pwdKey))) continue;
            this.parameters.remove(pwdKey);
        }
        HashMap<String, String> customParameters = new HashMap<String, String>();
        customParameters.putAll(this.parameters);
        customParameters.putAll(this.advancedParameters);
        try {
            this.setupConfigGenerator.saveFilteredConfiguration(customParameters);
        }
        catch (ConfigurationException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void resetParameters() {
        this.setupConfigGenerator = null;
        this.parameters = null;
        this.advancedParameters = null;
        Contexts.getPageContext().remove("setupConfigGenerator");
    }

    public void checkDatabaseParameters(FacesContext context, UIComponent component, Object value) {
        FacesMessage message;
        Map attributes = component.getAttributes();
        String dbNameInputId = (String)attributes.get("dbNameInputId");
        String dbUserInputId = (String)attributes.get("dbUserInputId");
        String dbPwdInputId = (String)attributes.get("dbPwdInputId");
        String dbHostInputId = (String)attributes.get("dbHostInputId");
        String dbPortInputId = (String)attributes.get("dbPortInputId");
        if (dbNameInputId == null || dbUserInputId == null || dbPwdInputId == null || dbHostInputId == null || dbPortInputId == null) {
            log.error((Object)"Cannot validate database parameters: missing inputIds");
            return;
        }
        UIInput dbNameComp = (UIInput)component.findComponent(dbNameInputId);
        UIInput dbUserComp = (UIInput)component.findComponent(dbUserInputId);
        UIInput dbPwdComp = (UIInput)component.findComponent(dbPwdInputId);
        UIInput dbHostComp = (UIInput)component.findComponent(dbHostInputId);
        UIInput dbPortComp = (UIInput)component.findComponent(dbPortInputId);
        if (dbNameComp == null || dbUserComp == null || dbPwdComp == null || dbHostComp == null || dbPortComp == null) {
            log.error((Object)"Cannot validate inputs: not found");
            return;
        }
        String dbName = (String)dbNameComp.getLocalValue();
        String dbUser = (String)dbUserComp.getLocalValue();
        String dbPwd = (String)dbPwdComp.getLocalValue();
        String dbHost = (String)dbHostComp.getLocalValue();
        Long dbPortLong = ((BigDecimal)dbPortComp.getLocalValue()).longValue();
        String dbPort = dbPortLong.toString();
        if (StringUtils.isEmpty((String)dbPwd)) {
            dbPwd = this.parameters.get("nuxeo.db.password");
        }
        String errorLabel = null;
        Throwable error = null;
        try {
            this.setupConfigGenerator.checkDatabaseConnection(this.parameters.get("nuxeo.dbtemplate"), dbName, dbUser, dbPwd, dbHost, dbPort);
        }
        catch (FileNotFoundException e) {
            errorLabel = ERROR_DB_FS;
            error = e;
        }
        catch (IOException e) {
            errorLabel = ERROR_DB_FS;
            error = e;
        }
        catch (DatabaseDriverException e) {
            errorLabel = ERROR_DB_DRIVER;
            error = e;
        }
        catch (SQLException e) {
            errorLabel = ERROR_DB_CONNECTION;
            error = e;
        }
        if (error != null) {
            log.error((Object)error, error);
            message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)errorLabel), null);
            throw new ValidatorException(message);
        }
        message = new FacesMessage(FacesMessage.SEVERITY_INFO, ComponentUtils.translate((FacesContext)context, (String)"error.db.none"), null);
        message.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage(component.getClientId(context), message);
    }

    public void templateChange(AjaxBehaviorEvent event) {
        UIComponent select = event.getComponent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        String dbTemplate = (String)((ValueHolder)select).getValue();
        this.setupConfigGenerator.changeDBTemplate(dbTemplate);
        this.setParameters();
        Contexts.getEventContext().remove("setupParams");
        Contexts.getEventContext().remove("advancedParams");
        FacesContext context = FacesContext.getCurrentInstance();
        context.renderResponse();
    }

    public void proxyChange(AjaxBehaviorEvent event) {
        UIComponent select = event.getComponent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        this.proxyType = (String)((ValueHolder)select).getValue();
        Contexts.getEventContext().remove("setupParams");
        FacesContext context = FacesContext.getCurrentInstance();
        context.renderResponse();
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyType(String proxyType) {
        this.proxyType = proxyType;
    }

    public String getDirectoryType() {
        return this.directoryType;
    }

    public void setDirectoryType(String directoryType) {
        this.parameters.put("nuxeo.directory.type", directoryType);
        this.directoryType = directoryType;
    }

    public void setDirectoryStorage(String directoryStorage) {
        this.parameters.put("nuxeo.user.group.storage", directoryStorage);
    }

    public void ldapStorageChange() {
        this.needGroupConfiguration = null;
    }

    public boolean getNeedGroupConfiguration() {
        if (this.needGroupConfiguration == null) {
            String storageType = this.parameters.get("nuxeo.user.group.storage");
            this.needGroupConfiguration = "userLdapOnly".equals(storageType) || "multiUserSqlGroup".equals(storageType) ? Boolean.FALSE : Boolean.TRUE;
        }
        return this.needGroupConfiguration;
    }

    public void directoryChange(AjaxBehaviorEvent event) {
        UIComponent select = event.getComponent();
        if (!(select instanceof ValueHolder)) {
            log.error((Object)("Bad component returned " + select));
            throw new AbortProcessingException("Bad component returned " + select);
        }
        this.directoryType = (String)((ValueHolder)select).getValue();
        if (DIRECTORY_MULTI.equals(this.directoryType)) {
            this.setDirectoryStorage("multiUserGroup");
        } else {
            this.setDirectoryStorage(DIRECTORY_DEFAULT);
        }
        this.needGroupConfiguration = null;
        Contexts.getEventContext().remove("setupParams");
        FacesContext context = FacesContext.getCurrentInstance();
        context.renderResponse();
    }

    public void checkLdapNetworkParameters(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String ldapUrlId = (String)attributes.get("directoryLdapUrl");
        if (ldapUrlId == null) {
            log.error((Object)"Cannot validate LDAP parameters: missing inputIds");
            return;
        }
        UIInput ldapUrlComp = (UIInput)component.findComponent(ldapUrlId);
        if (ldapUrlComp == null) {
            log.error((Object)"Cannot validate LDAP inputs: not found");
            return;
        }
        String ldapUrl = (String)ldapUrlComp.getLocalValue();
        String errorLabel = null;
        NamingException error = null;
        try {
            this.setupConfigGenerator.checkLdapConnection(ldapUrl, null, null, false);
        }
        catch (NamingException e) {
            errorLabel = ERROR_LDAP_CONNECTION;
            error = e;
        }
        if (error != null) {
            log.error((Object)error, (Throwable)error);
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)errorLabel), null);
            throw new ValidatorException(message);
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, ComponentUtils.translate((FacesContext)context, (String)"error.ldap.network.none"), null);
        message.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage(component.getClientId(context), message);
    }

    public void checkLdapAuthenticationParameters(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String ldapUrlId = (String)attributes.get("ldapUrl");
        String ldapBinddnId = (String)attributes.get("ldapBindDn");
        String ldapBindpwdId = (String)attributes.get("ldapBindPwd");
        if (ldapUrlId == null || ldapBinddnId == null || ldapBindpwdId == null) {
            log.error((Object)"Cannot validate LDAP parameters: missing inputIds");
            return;
        }
        UIInput ldapUrlComp = (UIInput)component.findComponent(ldapUrlId);
        UIInput ldapBinddnComp = (UIInput)component.findComponent(ldapBinddnId);
        UIInput ldapBindpwdComp = (UIInput)component.findComponent(ldapBindpwdId);
        if (ldapUrlComp == null || ldapBinddnComp == null || ldapBindpwdComp == null) {
            log.error((Object)"Cannot validate LDAP inputs: not found");
            return;
        }
        String ldapUrl = (String)ldapUrlComp.getLocalValue();
        String ldapBindDn = (String)ldapBinddnComp.getLocalValue();
        String ldapBindPwd = (String)ldapBindpwdComp.getLocalValue();
        String errorLabel = null;
        NamingException error = null;
        try {
            this.setupConfigGenerator.checkLdapConnection(ldapUrl, ldapBindDn, ldapBindPwd, true);
        }
        catch (NamingException e) {
            errorLabel = e instanceof AuthenticationException ? ERROR_LDAP_AUTHENTICATION : ERROR_LDAP_CONNECTION;
            error = e;
        }
        if (error != null) {
            log.error((Object)error, (Throwable)error);
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)errorLabel), null);
            throw new ValidatorException(message);
        }
        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_INFO, ComponentUtils.translate((FacesContext)context, (String)"error.ldap.auth.none"), null);
        message.setSeverity(FacesMessage.SEVERITY_INFO);
        context.addMessage(component.getClientId(context), message);
    }
}

