/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree;

import org.apache.directory.server.core.partition.impl.btree.TupleComparator;
import org.apache.directory.server.schema.SerializableComparator;

public class IndexComparator
implements TupleComparator {
    private static final long serialVersionUID = 3257283621751633459L;
    private static final SerializableComparator LONG_COMPARATOR = new SerializableComparator("1.3.6.1.4.1.18060.0.4.1.1.2"){
        private static final long serialVersionUID = 3690478030414165816L;

        public int compare(Object o1, Object o2) {
            try {
                long thisVal = (Long)o1;
                long anotherVal = (Long)o2;
                return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
            catch (NullPointerException npe) {
                if (o1 == null) {
                    throw new IllegalArgumentException("Argument 'obj1' is null");
                }
                throw new IllegalArgumentException("Argument 'obj2' is null");
            }
        }
    };
    private final boolean isForwardMap;
    private final SerializableComparator keyComp;

    public IndexComparator(SerializableComparator keyComp, boolean isForwardMap) {
        this.keyComp = keyComp;
        this.isForwardMap = isForwardMap;
    }

    public SerializableComparator getKeyComparator() {
        if (this.isForwardMap) {
            return this.keyComp;
        }
        return LONG_COMPARATOR;
    }

    public SerializableComparator getValueComparator() {
        if (this.isForwardMap) {
            return LONG_COMPARATOR;
        }
        return this.keyComp;
    }

    public int compareKey(Object key1, Object key2) {
        return this.getKeyComparator().compare(key1, key2);
    }

    public int compareValue(Object value1, Object value2) {
        return this.getValueComparator().compare(value1, value2);
    }
}

