/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.bean;

import fr.toutatice.ecm.checkin.helper.DocumentCheckinHelper;
import fr.toutatice.ecm.checkin.helper.DocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import fr.toutatice.ecm.platform.web.fragments.PageBean;
import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActionsBean;

@Name(value="checkinActions")
@Scope(value=ScopeType.CONVERSATION)
public class CheckinActions
implements Serializable {
    private static final long serialVersionUID = -5092427864129643896L;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    PathSegmentService pathSegmentService;
    @In(create=true)
    protected transient DocumentActionsBean documentActions;
    @In(create=true)
    protected PageBean pageBean;
    private static DocumentCheckinHelper checkinHelper = DocumentCheckinHelper.getInstance();

    public String createNCheckin() {
        DocumentModel draftDocBean = this.navigationContext.getChangeableDocument();
        DocumentModel checkoutParentDoc = this.navigationContext.getCurrentDocument();
        String docName = this.pathSegmentService.generatePathSegment(draftDocBean);
        String draftsFolderPath = checkinHelper.getDraftsFolderPath(this.documentManager, checkoutParentDoc);
        draftDocBean.setPathInfo(draftsFolderPath, docName);
        draftDocBean.addFacet("OttcDraft");
        draftDocBean.addFacet("WebidDisabled");
        DocumentModel draftDoc = this.documentManager.createDocument(draftDocBean);
        checkinHelper.setCheckinedParentId(draftDoc, checkoutParentDoc);
        this.documentManager.saveDocument(draftDoc);
        this.documentManager.save();
        this.pageBean.setNotificationKey("SUCCESS_MESSAGE_DRAFT_CREATED");
        ((ToutaticeDocumentActionsBean)this.documentActions).setLive(true);
        this.navigationContext.setCurrentDocument(draftDoc);
        return "done";
    }

    public String checkin() {
        DocumentModel checkinableDocBean = this.navigationContext.getCurrentDocument();
        DocumentModel checkinableDoc = this.documentManager.getDocument(checkinableDocBean.getRef());
        String draftsFolderId = checkinHelper.getDraftsFolderId(this.documentManager, checkinableDocBean);
        DocumentModel draftDoc = this.documentManager.copy(checkinableDoc.getRef(), (DocumentRef)new IdRef(draftsFolderId), null);
        draftDoc.addFacet("OttcDraft");
        draftDoc.addFacet("WebidDisabled");
        DocumentModel checkinedParent = this.documentManager.getParentDocument(checkinableDoc.getRef());
        checkinHelper.setCheckinedParentId(draftDoc, checkinedParent);
        checkinHelper.setCheckinedDocId(draftDoc, checkinableDoc);
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)this.documentManager, (DocumentModel)draftDoc, (boolean)false);
        checkinableDocBean.setPathInfo(DocumentHelper.getParentPath(this.documentManager, draftDoc), draftDoc.getName());
        draftDoc = this.documentManager.saveDocument(checkinableDocBean);
        DocumentModel checkinedDoc = checkinableDoc;
        checkinedDoc.addFacet("OttcCheckedIn");
        checkinedDoc.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
        Lock lockInfo = this.documentManager.getLockInfo(checkinedDoc.getRef());
        if (lockInfo != null) {
            this.documentManager.removeLock(checkinedDoc.getRef());
        }
        this.documentManager.setLock(checkinedDoc.getRef());
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)this.documentManager, (DocumentModel)checkinedDoc, (boolean)false);
        checkinedDoc.setPropertyValue("ottcChk:draftPath", (Serializable)((Object)draftDoc.getPathAsString()));
        checkinedDoc.setPropertyValue("ottcChk:draftId", (Serializable)((Object)DocumentHelper.getId(draftDoc)));
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)this.documentManager, (DocumentModel)checkinedDoc, (boolean)false);
        this.navigationContext.setCurrentDocument(draftDoc);
        this.documentManager.save();
        return "done";
    }

    public String checkout() {
        DocumentModel draftBean = this.navigationContext.getCurrentDocument();
        DocumentModel checkoutedDoc = null;
        if (!checkinHelper.hasCheckinedDoc(this.documentManager, draftBean)) {
            String checkoutParentId = checkinHelper.getCheckinedParentId(draftBean);
            draftBean.removeFacet("OttcDraft");
            draftBean.removeFacet("WebidDisabled");
            draftBean.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
            DocumentModel draftDoc = this.documentManager.saveDocument(draftBean);
            String checkoutParentPath = DocumentHelper.getPathFromId(this.documentManager, checkoutParentId);
            checkoutedDoc = this.documentManager.move(draftDoc.getRef(), (DocumentRef)new PathRef(checkoutParentPath), DocumentHelper.getCheckinedIdOfDraftDoc(draftDoc));
        } else {
            this.documentManager.removeDocument(draftBean.getRef());
            String checkinedDocId = DocumentHelper.getCheckinedIdOfDraftDoc(draftBean);
            DocumentModel checkinedDoc = WebIdResolver.getLiveDocumentByWebId((CoreSession)this.documentManager, (String)checkinedDocId);
            draftBean.setPathInfo(DocumentHelper.getParentPath(this.documentManager, checkinedDoc), checkinedDoc.getName());
            draftBean.putContextData("VersioningOption", (Serializable)VersioningOption.MINOR);
            draftBean.removeFacet("OttcDraft");
            draftBean = DocumentHelper.setDirty(draftBean);
            checkoutedDoc = this.documentManager.saveDocument(draftBean);
        }
        this.navigationContext.setCurrentDocument(checkoutedDoc);
        this.documentManager.save();
        return "done";
    }

    public boolean isDraft() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return currentDocument.hasFacet("OttcDraft");
    }
}

