/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.helper;

import fr.toutatice.ecm.checkin.helper.DocumentHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;

public class DocumentCheckinHelper {
    private static final Log log = LogFactory.getLog(DocumentCheckinHelper.class);
    private static DocumentCheckinHelper instance;
    private static UserWorkspaceService uwService;

    private DocumentCheckinHelper() {
    }

    public static synchronized DocumentCheckinHelper getInstance() {
        if (instance == null) {
            instance = new DocumentCheckinHelper();
        }
        return instance;
    }

    public static UserWorkspaceService getUserWorkspaceService() {
        if (uwService == null) {
            uwService = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
        }
        return uwService;
    }

    public boolean isDraft(DocumentModel document) {
        return document.hasFacet("OttcDraft");
    }

    public boolean hasDraft(DocumentModel document) {
        return document.hasFacet("OttcCheckedIn");
    }

    public String getCheckinedParentId(DocumentModel draft) {
        if (draft != null) {
            return (String)((Object)draft.getPropertyValue("ottcDft:checkoutParentId"));
        }
        return "";
    }

    public void setCheckinedParentId(DocumentModel draft, DocumentModel checkinedParent) {
        if (draft != null && checkinedParent != null) {
            String checkinedParentId = DocumentHelper.getId(checkinedParent);
            draft.setPropertyValue("ottcDft:checkoutParentId", (Serializable)((Object)checkinedParentId));
        }
    }

    public String getCheckinedId(DocumentModel draft) {
        if (draft != null) {
            String checkinedId = (String)((Object)draft.getPropertyValue("ottcDft:checkinedDocId"));
            return StringUtils.isNotBlank((String)checkinedId) ? checkinedId : "";
        }
        return "";
    }

    public void setCheckinedDocId(DocumentModel draft, DocumentModel checkinedDoc) {
        if (draft != null && checkinedDoc != null) {
            String checkinedDocId = DocumentHelper.getId(checkinedDoc);
            draft.setPropertyValue("ottcDft:checkinedDocId", (Serializable)((Object)checkinedDocId));
        }
    }

    public boolean hasCheckinedDoc(CoreSession session, DocumentModel draft) {
        String checkinedId = DocumentHelper.getCheckinedIdOfDraftDoc(draft);
        DocumentModel checkinedDoc = WebIdResolver.getLiveDocumentByWebId((CoreSession)session, (String)checkinedId);
        return checkinedDoc != null && checkinedDoc.hasFacet("OttcCheckedIn");
    }

    public DocumentModel getDraftDoc(CoreSession session, DocumentModel checkinedDoc) {
        String draftId = DocumentHelper.getDraftIdFromCheckinedDoc(checkinedDoc);
        return WebIdResolver.getLiveDocumentByWebId((CoreSession)session, (String)draftId);
    }

    public String getDraftsFolderId(CoreSession documentManager, DocumentModel currentDoc) {
        return this.getDraftFolder(documentManager, currentDoc).getId();
    }

    public String getDraftsFolderPath(CoreSession session, DocumentModel document) {
        return this.getDraftFolder(session, document).getPathAsString();
    }

    public DocumentModel getDraftFolder(CoreSession session, DocumentModel currentDoc) {
        DocumentModel draftsFolder;
        block3: {
            DocumentModel userWorkspace = this.getUserWorkspace(session, currentDoc);
            draftsFolder = null;
            try {
                draftsFolder = session.getChild(userWorkspace.getRef(), "drafts");
            }
            catch (ClientException ce) {
                if (!NoSuchDocumentException.class.isInstance(ce.getCause())) break block3;
                draftsFolder = this.createDraftsFolder(session, userWorkspace);
            }
        }
        if (!draftsFolder.hasFacet("HiddenInNavigation")) {
            draftsFolder.addFacet("HiddenInNavigation");
            draftsFolder = session.saveDocument(draftsFolder);
        }
        return draftsFolder;
    }

    protected DocumentModel createDraftsFolder(CoreSession documentManager, DocumentModel userWorkspace) {
        DocumentModel d = documentManager.createDocumentModel(userWorkspace.getPathAsString(), "drafts", "Folder");
        d.setPropertyValue("dc:title", (Serializable)((Object)"Mes brouillons"));
        String suffix = StringUtils.replace((String)documentManager.getPrincipal().getName(), (String)"_", (String)"-");
        String webid = "drafts_" + suffix;
        d.setPropertyValue("ttc:webid", (Serializable)((Object)webid));
        DocumentModel draftFolder = documentManager.createDocument(d);
        draftFolder.addFacet("HiddenInNavigation");
        return documentManager.saveDocument(draftFolder);
    }

    protected DocumentModel getUserWorkspace(CoreSession session, DocumentModel currentDocument) {
        return DocumentCheckinHelper.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, currentDocument);
    }

    public void restoreCheckinedDoc(CoreSession session, String checkinedId) {
        if (StringUtils.isNotEmpty((String)checkinedId)) {
            DocumentModel checkinedDoc = WebIdResolver.getLiveDocumentByWebId((CoreSession)session, (String)checkinedId);
            if (checkinedDoc != null) {
                this.removeDraftInfosOn(session, checkinedDoc);
            } else if (StringUtils.isNotEmpty((String)checkinedId)) {
                log.error((Object)"No Draft document with webid: ".concat(checkinedId));
            }
        }
    }

    public void restoreCheckinedDoc(CoreSession session, DocumentModel checkinedDoc) {
        this.removeDraftInfosOn(session, checkinedDoc);
    }

    public void removeDraftInfosOn(CoreSession session, DocumentModel checkinedDoc) {
        checkinedDoc.removeFacet("OttcCheckedIn");
        session.removeLock(checkinedDoc.getRef());
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)checkinedDoc, (boolean)false);
    }
}

