/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.helper;

import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import java.util.Collection;
import java.util.Set;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static String getId(DocumentModel document) {
        return (String)((Object)document.getPropertyValue("ttc:webid"));
    }

    public static String getPathFromId(CoreSession session, String webId) {
        DocumentModel document = WebIdResolver.getLiveDocumentByWebId((CoreSession)session, (String)webId);
        if (document != null) {
            return document.getPathAsString();
        }
        return "";
    }

    public static String getParentPath(CoreSession session, DocumentModel document) {
        DocumentRef parentRef = document.getParentRef();
        DocumentModel parent = session.getDocument(parentRef);
        if (parent != null) {
            return parent.getPathAsString();
        }
        return null;
    }

    public static String getParentId(CoreSession session, DocumentModel document) {
        DocumentRef parentRef = document.getParentRef();
        DocumentModel parent = session.getDocument(parentRef);
        if (parent != null) {
            return DocumentHelper.getId(parent);
        }
        return null;
    }

    public static String getPath(CoreSession session, DocumentRef documentRef) {
        DocumentModel document = session.getDocument(documentRef);
        if (document != null) {
            return document.getPathAsString();
        }
        return "";
    }

    public static String getCheckinedIdOfDraftDoc(DocumentModel draft) {
        if (draft.hasFacet("OttcDraft")) {
            return (String)((Object)draft.getPropertyValue("ottcDft:checkinedDocId"));
        }
        return "";
    }

    public static String getDraftIdFromCheckinedDoc(DocumentModel checkined) {
        if (checkined.hasFacet("OttcCheckedIn")) {
            return (String)((Object)checkined.getPropertyValue("ottcChk:draftId"));
        }
        return "";
    }

    public static DocumentModel setDirty(DocumentModel document) {
        Collection dataModelsCollection = document.getDataModelsCollection();
        if (dataModelsCollection != null) {
            for (DataModel dm : dataModelsCollection) {
                Set fieldsNames = dm.getMap().keySet();
                for (String fieldName : fieldsNames) {
                    dm.setDirty(fieldName);
                }
            }
        }
        return document;
    }
}

