/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.listener;

import fr.toutatice.ecm.checkin.helper.DocumentHelper;
import fr.toutatice.ecm.checkin.helper.TransitionHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

public class AsyncFolderishListener
implements PostCommitFilteringEventListener {
    public static Log log = LogFactory.getLog(AsyncFolderishListener.class);
    private static TrashService trashService;
    private boolean isDeletion = false;
    private boolean isUndeletion = false;
    private boolean isRemoved = false;

    protected TrashService getTrashService() {
        if (trashService == null) {
            trashService = (TrashService)Framework.getService(TrashService.class);
        }
        return trashService;
    }

    public boolean acceptEvent(Event event) {
        if (event.getContext() instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            if ("documentRemoved".equals(event.getName())) {
                this.isRemoved = true;
                return this.isRemoved;
            }
            this.isDeletion = TransitionHelper.isTransition(docCtx, event, "delete");
            this.isUndeletion = TransitionHelper.isTransition(docCtx, event, "undelete");
            return this.isDeletion || this.isUndeletion;
        }
        return false;
    }

    public void handleEvent(EventBundle events) throws ClientException {
        for (Event event : events) {
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            DocumentModel srcDoc = docCtx.getSourceDocument();
            CoreSession session = docCtx.getCoreSession();
            if (srcDoc == null || !srcDoc.isFolder()) continue;
            if ("lifecycle_transition_event".equals(event.getName())) {
                this.deleteOrRestoreOrphansDrafts(session, srcDoc);
                continue;
            }
            if (!this.isRemoved) continue;
            this.removeDrafts(docCtx, session, srcDoc);
        }
    }

    protected void deleteOrRestoreOrphansDrafts(CoreSession session, DocumentModel folder) {
        String parentId = DocumentHelper.getId(folder);
        DocumentModelList orphanDrafts = session.query(String.format("select * from Document where ecm:mixinType = \"OttcDraft\" and ottcDft:checkinedDocId = \"\" and ottcDft:checkoutParentId = \"%s\" and ecm:isProxy = 0 and ecm:isVersion = 0", parentId));
        if (orphanDrafts.size() > 0) {
            for (DocumentModel orphan : orphanDrafts) {
                session.followTransition(orphan, TransitionHelper.getTransitionName(this.isDeletion));
            }
            session.save();
        }
    }

    protected void removeDrafts(DocumentEventContext docCtx, CoreSession session, DocumentModel folder) {
        DocumentModelList drafts;
        String parentIdList = (String)((Object)docCtx.getProperty("parentCheckoutIds"));
        if (StringUtils.isNotBlank((String)parentIdList) && (drafts = session.query(String.format("select * from Document where ecm:mixinType = \"OttcDraft\" and ottcDft:checkoutParentId in %s and ecm:currentLifeCycleState = 'deleted' and ecm:isProxy = 0 and ecm:isVersion = 0", parentIdList))).size() > 0) {
            for (DocumentModel draft : drafts) {
                ToutaticeDocumentHelper.removeDocumentSilently((CoreSession)session, (DocumentModel)draft, (boolean)false);
            }
            session.save();
        }
    }
}

