/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.listener;

import fr.toutatice.ecm.checkin.helper.DocumentCheckinHelper;
import fr.toutatice.ecm.checkin.helper.TransitionHelper;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class CheckinedListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext context = event.getContext();
        if (context instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)context;
            DocumentModel srcDoc = docCtx.getSourceDocument();
            CoreSession session = docCtx.getCoreSession();
            DocumentCheckinHelper checkinHelper = DocumentCheckinHelper.getInstance();
            if (checkinHelper.hasDraft(srcDoc)) {
                if ("documentMoved".equals(event.getName())) {
                    this.updateDraft(srcDoc, session, checkinHelper);
                } else if ("lifecycle_transition_event".equals(event.getName())) {
                    String transition = TransitionHelper.getTransition(docCtx, event);
                    if (StringUtils.isNotEmpty((String)transition)) {
                        this.updateDraftLifeCycle(session, srcDoc, transition);
                    }
                } else if ("aboutToRemove".equals(event.getName())) {
                    this.removeDraft(session, srcDoc);
                } else if ("documentCreatedByCopy".equals(event.getName())) {
                    checkinHelper.restoreCheckinedDoc(session, srcDoc);
                }
            }
        }
    }

    public void updateDraft(DocumentModel srcDoc, CoreSession session, DocumentCheckinHelper checkinHelper) {
        DocumentModel checkinedParent = session.getParentDocument(srcDoc.getRef());
        DocumentModel draft = checkinHelper.getDraftDoc(session, srcDoc);
        checkinHelper.setCheckinedParentId(draft, checkinedParent);
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)draft, (boolean)true);
    }

    private void updateDraftLifeCycle(CoreSession session, DocumentModel checkinedDoc, String transition) {
        DocumentModel draft = DocumentCheckinHelper.getInstance().getDraftDoc(session, checkinedDoc);
        session.followTransition(draft, transition);
    }

    private void removeDraft(CoreSession session, DocumentModel checkinedDoc) {
        DocumentModel draft = DocumentCheckinHelper.getInstance().getDraftDoc(session, checkinedDoc);
        ToutaticeDocumentHelper.removeDocumentSilently((CoreSession)session, (DocumentModel)draft, (boolean)false);
        session.save();
    }
}

