/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.portal.infos.provider;

import fr.toutatice.ecm.checkin.helper.DocumentCheckinHelper;
import fr.toutatice.ecm.checkin.helper.DocumentHelper;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class CheckinFolderishInfosProvider
implements DocumentInformationsProvider {
    private static final Log log = LogFactory.getLog(CheckinFolderishInfosProvider.class);
    private static boolean isEsEnabled;
    private final ElasticSearchService esService;

    public CheckinFolderishInfosProvider() {
        isEsEnabled = Framework.isBooleanPropertyTrue((String)"elasticsearch.enabled");
        this.esService = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        long begin = System.currentTimeMillis();
        HashMap<String, Object> infos = new HashMap<String, Object>(1);
        if (currentDocument.isFolder()) {
            long b1 = System.currentTimeMillis();
            String draftsFolderId = DocumentCheckinHelper.getInstance().getDraftsFolderId(coreSession, currentDocument);
            if (log.isTraceEnabled()) {
                long e1 = System.currentTimeMillis();
                log.trace((Object)(" [getDraftsFolderPath]: " + String.valueOf(e1 - b1 + " ms")));
            }
            String checkoutParentId = DocumentHelper.getId(currentDocument);
            StringBuilder query = new StringBuilder();
            query.append("SELECT ecm:uuid FROM Document ");
            query.append("WHERE ecm:parentId = '").append(draftsFolderId).append("' ");
            query.append("AND ecm:currentLifeCycleState <> 'deleted' ");
            query.append("AND ottcDft:checkoutParentId = '").append(checkoutParentId).append("' ");
            long b2 = System.currentTimeMillis();
            long draftCount = 0L;
            if (isEsEnabled) {
                NxQueryBuilder queryBuilder = new NxQueryBuilder(coreSession).nxql(query.toString());
                EsResult draftsIds = this.esService.queryAndAggregate(queryBuilder);
                if (draftsIds != null && draftsIds.getRows() != null) {
                    draftCount = draftsIds.getRows().size();
                }
            } else {
                try (IterableQueryResult draftsRows = null;){
                    draftsRows = coreSession.queryAndFetch(query.toString(), "NXQL", new Object[0]);
                    if (draftsRows != null) {
                        draftCount = draftsRows.size();
                    }
                }
            }
            if (log.isTraceEnabled()) {
                long e2 = System.currentTimeMillis();
                log.trace((Object)(" [Drafts count]: " + String.valueOf(e2 - b2 + " ms")));
            }
            infos.put("draftCount", draftCount);
        }
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)(": " + String.valueOf(end - begin) + " ms"));
        }
        return infos;
    }
}

