/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.checkin.portal.infos.provider;

import fr.toutatice.ecm.checkin.helper.DocumentCheckinHelper;
import fr.toutatice.ecm.checkin.helper.DocumentHelper;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

public class CheckinInfosProvider
implements DocumentInformationsProvider {
    private static final Log log = LogFactory.getLog(CheckinInfosProvider.class);

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        long begin = System.currentTimeMillis();
        HashMap<String, Object> infos = new HashMap<String, Object>();
        if (currentDocument.hasFacet("OttcCheckedIn")) {
            String owner = currentDocument.getLockInfo().getOwner();
            if (coreSession.getPrincipal().getName().equals(owner)) {
                String draftId = DocumentHelper.getDraftIdFromCheckinedDoc(currentDocument);
                DocumentModel draft = WebIdResolver.getLiveDocumentByWebId((CoreSession)coreSession, (String)draftId);
                String draftPath = "";
                if (draft != null) {
                    draftPath = draft.getPathAsString();
                } else {
                    log.error((Object)"Document with webId: ".concat(draftId).concat(" does not exist"));
                }
                try {
                    infos.put("draftPath", URLEncoder.encode(draftPath, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new ClientException((Throwable)e);
                }
            }
        }
        if (currentDocument.hasFacet("OttcDraft")) {
            DocumentCheckinHelper checkinHelper = DocumentCheckinHelper.getInstance();
            boolean hasCheckinedDoc = checkinHelper.hasCheckinedDoc(coreSession, currentDocument);
            String checkinedParentId = checkinHelper.getCheckinedParentId(currentDocument);
            String draftContainerPath = "";
            DocumentModel checkinedParent = WebIdResolver.getLiveDocumentByWebId((CoreSession)coreSession, (String)checkinedParentId);
            if (checkinedParent != null) {
                draftContainerPath = DocumentHelper.getPathFromId(coreSession, checkinedParentId);
            } else {
                log.error((Object)"Draft '".concat(currentDocument.getName()).concat("' is orphan"));
            }
            try {
                infos.put("draftContextualizationPath", URLEncoder.encode(draftContainerPath, "UTF-8"));
                infos.put("hasCheckinedDoc", URLEncoder.encode(String.valueOf(hasCheckinedDoc), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            long end = System.currentTimeMillis();
            log.trace((Object)(": " + String.valueOf(end - begin) + " ms"));
        }
        return infos;
    }
}

