/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.ui.bean;

import fr.toutatice.ecm.platform.service.fragments.configuration.ConfigurationBeanHelper;
import fr.toutatice.ecm.platform.web.document.ToutaticeWebActionsBean;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutDefinition;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.runtime.api.Framework;

@Name(value="config")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=81)
public class MetadataConfigurationBeanHelper
extends ConfigurationBeanHelper {
    public static final String METADATA_IN_NX_BO = "ottc.metadata.show.nx.bo";
    private static final String ANY_MODE = "any";
    public static final String DEFAULT_METADATA_LAYOUT = "ottc_metadata";
    public static final String ENABLED_IN_CREATION_MODE = "enabledInCreation";
    public static final String CONTENT_LABEL = "contentLabel";
    public static final String METADATA_LABEL = "metadataLabel";
    public static final String BOOTSRAP_RIGHT_COLS = "bootstrapRightCols";
    public static final String EXCLUDED_DEFAULT_METADATA_TYPES = "excludedDefaultMetadataTypes";
    private static Map<String, String[]> customTypes;
    private static WebLayoutManager layoutManager;

    public static WebLayoutManager getLayoutManager() {
        if (layoutManager == null) {
            layoutManager = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
            MetadataConfigurationBeanHelper.initLayoutManager();
        }
        return layoutManager;
    }

    public static Map<String, String[]> getCustomTypes() {
        if (customTypes == null) {
            customTypes = new HashMap<String, String[]>(0);
            MetadataConfigurationBeanHelper.getLayoutManager();
        }
        return customTypes;
    }

    private static void initLayoutManager() {
        List layoutNames = MetadataConfigurationBeanHelper.getLayoutManager().getLayoutDefinitionNames();
        for (String layoutName : layoutNames) {
            String[] excludedTypes;
            Map anyModProperties;
            LayoutDefinition layout = MetadataConfigurationBeanHelper.getLayoutManager().getLayoutDefinition(layoutName);
            Map properties = layout.getProperties();
            if (properties == null || !properties.containsKey(ANY_MODE) || (anyModProperties = (Map)properties.get(ANY_MODE)) == null || !anyModProperties.containsKey(EXCLUDED_DEFAULT_METADATA_TYPES) || (excludedTypes = (String[])anyModProperties.get(EXCLUDED_DEFAULT_METADATA_TYPES)) == null || excludedTypes.length <= 0) continue;
            customTypes.put(layoutName, excludedTypes);
        }
    }

    public Boolean isEnabledInCreateMode(DocumentModel document) {
        Map<String, Serializable> properties = this.getLayoutProperty(document);
        return Boolean.valueOf((String)((Object)properties.get(ENABLED_IN_CREATION_MODE)));
    }

    public String getMetadataLayout(DocumentModel document) {
        String docType = document.getType();
        for (Map.Entry<String, String[]> entry : MetadataConfigurationBeanHelper.getCustomTypes().entrySet()) {
            Object[] excludedTypes = entry.getValue();
            if (excludedTypes == null || !ArrayUtils.contains((Object[])excludedTypes, (Object)docType)) continue;
            return entry.getKey();
        }
        return DEFAULT_METADATA_LAYOUT;
    }

    public String getContentLabel(DocumentModel document) {
        Map<String, Serializable> properties = this.getLayoutProperty(document);
        return (String)((Object)properties.get(CONTENT_LABEL));
    }

    public String getMetadataLabel(DocumentModel document) {
        Map<String, Serializable> properties = this.getLayoutProperty(document);
        return (String)((Object)properties.get(METADATA_LABEL));
    }

    public Integer getRightCols(DocumentModel document) {
        Map<String, Serializable> properties = this.getLayoutProperty(document);
        return Integer.valueOf((String)((Object)properties.get(BOOTSRAP_RIGHT_COLS)));
    }

    private Map<String, Serializable> getLayoutProperty(DocumentModel document) {
        String layoutName = this.getMetadataLayout(document);
        LayoutDefinition layout = MetadataConfigurationBeanHelper.getLayoutManager().getLayoutDefinition(layoutName);
        Map properties = layout.getProperties(ANY_MODE);
        return properties != null ? properties : new HashMap(0);
    }

    public boolean showMetadataInNx() {
        ToutaticeWebActionsBean webBean = (ToutaticeWebActionsBean)SeamComponentCallHelper.getSeamComponentByName((String)"webActions");
        boolean isNotInPVContext = !webBean.isInPortalViewContext();
        boolean showInBO = Boolean.valueOf(Framework.getProperty((String)METADATA_IN_NX_BO));
        return isNotInPVContext && showInBO;
    }

    public boolean isWebModeActive() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            return currentDocument.hasSchema("ottc_web");
        }
        return false;
    }
}

