/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.listener;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.collections.core.adapter.CollectionMember;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class DuplicatedCollectionListener
implements EventListener {
    private static final Log log = LogFactory.getLog(DuplicatedCollectionListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        String eventId = event.getName();
        DocumentEventContext docCxt = (DocumentEventContext)event.getContext();
        DocumentModel doc = null;
        if (eventId.equals("documentCreatedByCopy")) {
            doc = docCxt.getSourceDocument();
        } else if (eventId.equals("documentCheckedIn")) {
            DocumentRef checkedInVersionRef = (DocumentRef)ctx.getProperties().get("checkedInVersionRef");
            doc = ctx.getCoreSession().getDocument(checkedInVersionRef);
            if (!doc.isVersion()) {
                return;
            }
        } else {
            return;
        }
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        if (collectionManager.isCollection(doc)) {
            if (eventId.equals("documentCreatedByCopy")) {
                log.trace((Object)String.format("Collection %s copied", doc.getId()));
            } else if (eventId.equals("documentCheckedIn")) {
                log.trace((Object)String.format("Collection %s checked in", doc.getId()));
            }
            collectionManager.processCopiedCollection(doc);
        } else if (collectionManager.isCollected(doc)) {
            ((CollectionMember)doc.getAdapter(CollectionMember.class)).setCollectionIds(null);
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
            ctx.getCoreSession().saveDocument(doc);
            doc.removeFacet("CollectionMember");
        }
    }
}

