/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.collections.core.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class RemovedCollectionListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(RemovedCollectionListener.class);

    public void handleEvent(EventBundle bundle) throws ClientException {
        for (Event each : bundle) {
            String eventId;
            EventContext ctx = each.getContext();
            if (!(ctx instanceof DocumentEventContext) || !(eventId = each.getName()).equals("documentRemoved")) continue;
            this.onEvent(each);
        }
    }

    protected void onEvent(Event event) throws ClientException {
        DocumentEventContext docCxt = (DocumentEventContext)event.getContext();
        DocumentModel doc = docCxt.getSourceDocument();
        CollectionManager collectionManager = (CollectionManager)Framework.getLocalService(CollectionManager.class);
        boolean isCollectionRemoved = collectionManager.isCollection(doc);
        boolean isCollectionMemberRemoved = collectionManager.isCollected(doc);
        if (isCollectionRemoved || isCollectionMemberRemoved) {
            if (isCollectionRemoved) {
                log.trace((Object)String.format("Collection %s removed", doc.getId()));
                collectionManager.processRemovedCollection(doc);
            } else if (isCollectionMemberRemoved) {
                log.trace((Object)String.format("CollectionMember %s removed", doc.getId()));
                collectionManager.processRemovedCollectionMember(doc);
            }
        }
    }
}

