/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.EraseModifications", category="Document", label="Erase unpublished modifications of live document yet locally published", description="Erase unpublished modifications of live document yet locally published. This live is given as input")
public class EraseModifications {
    public static final String ID = "Document.EraseModifications";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Param(name="skipCreateVersion", required=false, values={"false"})
    protected boolean skipCreateVersion = false;
    @Param(name="skipCheckout", required=false, values={"false"})
    protected boolean skipCheckout = false;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef docRef) throws Exception {
        DocumentModel publishedDocument;
        DocumentModel document = this.session.getDocument(docRef);
        if (!document.isProxy() && !document.isVersion()) {
            publishedDocument = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)document, (String)"Read");
            if (publishedDocument == null) {
                throw new Exception("Input live document is not yet locally published.");
            }
        } else {
            throw new Exception("Input document is not a working copy.");
        }
        DocumentModel publishedVersion = this.session.getSourceDocument(publishedDocument.getRef());
        this.session.restoreToVersion(document.getRef(), publishedVersion.getRef(), this.skipCreateVersion, this.skipCheckout);
        return this.session.getDocument(docRef);
    }
}

