/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.security;

import fr.toutatice.ecm.platform.core.security.MasterOwnerSecurityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.TypeAdaptException;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class ACEsOperationHelper {
    private ACEsOperationHelper() {
    }

    public static ACE getBlockInheritanceACe() {
        return new ACE("Everyone", "Everything", false);
    }

    public static List<ACE> buildACEs(OperationContext ctx, Properties aces) throws TypeAdaptException {
        ArrayList<ACE> aceEntries = new ArrayList<ACE>(0);
        if (aces != null) {
            for (Map.Entry aceProp : aces.entrySet()) {
                String[] permissions;
                String permsAsString = StringUtils.substringBetween((String)((String)aceProp.getValue()), (String)"[", (String)"]");
                if (permsAsString == null || (permissions = permsAsString.split(",")) == null) continue;
                for (String permission : permissions) {
                    ACE aceEntry = new ACE((String)aceProp.getKey(), StringUtils.trimToEmpty((String)permission));
                    aceEntries.add(aceEntry);
                }
            }
        }
        return aceEntries;
    }

    public static ACL buildDefaultLocalACL(CoreSession session, DocumentModel document) {
        ACLImpl acl = new ACLImpl();
        String currentUser = session.getPrincipal().getName();
        acl.add((Object)new ACE(currentUser, "Everything"));
        acl.addAll(ACEsOperationHelper.getMasterOwnerACEs(session, document));
        return acl;
    }

    public static List<ACE> getAdminEverythingACEs() {
        ArrayList<ACE> result = new ArrayList<ACE>();
        UserManager um = (UserManager)Framework.getLocalService(UserManager.class);
        List administratorsGroups = um.getAdministratorsGroups();
        for (String adminGroup : administratorsGroups) {
            result.add(new ACE(adminGroup, "Everything", true));
        }
        return result;
    }

    public static List<ACE> getMasterOwnerACEs(CoreSession session, DocumentModel document) {
        ArrayList<ACE> acEs = new ArrayList<ACE>(0);
        List masterOwners = MasterOwnerSecurityHelper.getMasterOwners((CoreSession)session, (DocumentModel)document);
        for (String masterOwner : masterOwners) {
            ACE ace = new ACE(masterOwner, "MasterOwner");
            acEs.add(ace);
        }
        return acEs;
    }
}

