/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.security;

import fr.toutatice.ecm.platform.automation.security.AbstractACEsOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;

@Operation(id="Document.RemoveACEs")
public class RemoveACEs
extends AbstractACEsOperation {
    public static final String ID = "Document.RemoveACEs";
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;
    @Param(name="acl", required=false, values={"inherited", "local"})
    protected String aclName = "local";
    @Param(name="all")
    protected boolean removeAll;
    @Param(name="aces", required=false)
    protected Properties aces;
    @Param(name="userNames", required=false)
    protected StringList userNames;
    @Param(name="blockInheritance", required=false)
    protected boolean blockInheritance = false;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        document = this.removeAll ? super.execute(this.session, document, this.aclName) : super.execute(this.ctx, this.session, document, this.aclName, this.aces, this.blockInheritance);
        return document;
    }

    @Override
    protected ACL modifyACEs(ACL acl, List<ACE> aces) {
        if (this.removeAll) {
            return null;
        }
        ACL treatAcl = (ACL)acl.clone();
        boolean deleteByUsers = CollectionUtils.isNotEmpty((Collection)this.userNames);
        if (deleteByUsers) {
            for (String userName : this.userNames) {
                for (ACE ace : acl) {
                    if (!ace.getUsername().equals(userName)) continue;
                    treatAcl.remove((Object)ace);
                }
            }
        }
        acl = treatAcl;
        for (ACE ace : aces) {
            if (!acl.contains((Object)ace)) continue;
            acl.remove((Object)ace);
        }
        return acl;
    }
}

