/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBApiLayer;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoAuthority;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoOptions;
import com.mongodb.MongoURI;
import com.mongodb.ReadPreference;
import com.mongodb.ReplicaSetStatus;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.bson.io.PoolOutputBuffer;
import org.bson.util.SimplePool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    static Logger logger = Logger.getLogger(Bytes.LOGGER.getName() + ".Mongo");
    @Deprecated
    public static final int MAJOR_VERSION = 2;
    @Deprecated
    public static final int MINOR_VERSION = 12;
    private static final String FULL_VERSION = "2.12.1";
    static int cleanerIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.cleanerIntervalMS", "1000"));
    private static final String ADMIN_DATABASE_NAME = "admin";
    final MongoOptions _options;
    final DBTCPConnector _connector;
    final ConcurrentMap<String, DB> _dbs = new ConcurrentHashMap<String, DB>();
    private WriteConcern _concern = WriteConcern.NORMAL;
    private ReadPreference _readPref = ReadPreference.primary();
    final Bytes.OptionHolder _netOptions = new Bytes.OptionHolder(null);
    final CursorCleanerThread _cleaner;
    final MongoAuthority _authority;
    SimplePool<PoolOutputBuffer> _bufferPool = new SimplePool<PoolOutputBuffer>(1000){

        @Override
        protected PoolOutputBuffer createNew() {
            return new PoolOutputBuffer();
        }
    };

    @Deprecated
    public static int getMajorVersion() {
        return 2;
    }

    @Deprecated
    public static int getMinorVersion() {
        return 12;
    }

    @Deprecated
    public static DB connect(DBAddress addr) {
        return new Mongo(addr).getDB(addr.getDBName());
    }

    @Deprecated
    public Mongo() throws UnknownHostException {
        this(new ServerAddress());
    }

    @Deprecated
    public Mongo(String host) throws UnknownHostException {
        this(new ServerAddress(host));
    }

    @Deprecated
    public Mongo(String host, MongoOptions options) throws UnknownHostException {
        this(new ServerAddress(host), options);
    }

    @Deprecated
    public Mongo(String host, int port) throws UnknownHostException {
        this(new ServerAddress(host, port));
    }

    @Deprecated
    public Mongo(ServerAddress addr) {
        this(addr, new MongoOptions());
    }

    @Deprecated
    public Mongo(ServerAddress addr, MongoOptions options) {
        this(MongoAuthority.direct(addr), options);
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right) {
        this(left, right, new MongoOptions());
    }

    @Deprecated
    public Mongo(ServerAddress left, ServerAddress right, MongoOptions options) {
        this(MongoAuthority.dynamicSet(Arrays.asList(left, right)), options);
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds) {
        this(seeds, new MongoOptions());
    }

    @Deprecated
    public Mongo(List<ServerAddress> seeds, MongoOptions options) {
        this(MongoAuthority.dynamicSet(seeds), options);
    }

    @Deprecated
    public Mongo(MongoURI uri) throws UnknownHostException {
        this(Mongo.getMongoAuthorityFromURI(uri), uri.getOptions());
    }

    Mongo(MongoAuthority authority, MongoOptions options) {
        logger.info("Creating Mongo instance (driver version " + this.getVersion() + ") with authority " + authority + " and options " + options);
        this._authority = authority;
        this._options = options;
        this._applyMongoOptions();
        this._connector = new DBTCPConnector(this);
        this._connector.start();
        if (this._options.cursorFinalizerEnabled) {
            this._cleaner = new CursorCleanerThread();
            this._cleaner.start();
        } else {
            this._cleaner = null;
        }
    }

    public DB getDB(String dbname) {
        DB db = (DB)this._dbs.get(dbname);
        if (db != null) {
            return db;
        }
        db = new DBApiLayer(this, dbname, this._connector);
        DB temp = this._dbs.putIfAbsent(dbname, db);
        if (temp != null) {
            return temp;
        }
        return db;
    }

    public Collection<DB> getUsedDatabases() {
        return this._dbs.values();
    }

    public List<String> getDatabaseNames() {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        CommandResult res = this.getDB(ADMIN_DATABASE_NAME).command((DBObject)cmd, this.getOptions());
        res.throwOnError();
        List l = (List)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public void dropDatabase(String dbName) {
        this.getDB(dbName).dropDatabase();
    }

    public String getVersion() {
        return FULL_VERSION;
    }

    @Deprecated
    public String debugString() {
        return this._connector.debugString();
    }

    public String getConnectPoint() {
        return this._connector.getConnectPoint();
    }

    @Deprecated
    public DBTCPConnector getConnector() {
        return this._connector;
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        return this._connector.getReplicaSetStatus();
    }

    public ServerAddress getAddress() {
        return this._connector.getAddress();
    }

    public List<ServerAddress> getAllAddress() {
        List<ServerAddress> result = this._connector.getAllAddress();
        if (result == null) {
            return Arrays.asList(this.getAddress());
        }
        return result;
    }

    public List<ServerAddress> getServerAddressList() {
        return this._connector.getServerAddressList();
    }

    public void close() {
        try {
            this._connector.close();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this._cleaner != null) {
            this._cleaner.interrupt();
            try {
                this._cleaner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        return this._concern;
    }

    public void setReadPreference(ReadPreference preference) {
        this._readPref = preference;
    }

    public ReadPreference getReadPreference() {
        return this._readPref;
    }

    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._netOptions.add(option);
    }

    public void setOptions(int options) {
        this._netOptions.set(options);
    }

    public void resetOptions() {
        this._netOptions.reset();
    }

    public int getOptions() {
        return this._netOptions.get();
    }

    void _applyMongoOptions() {
        if (this._options.slaveOk) {
            this.slaveOk();
        }
        if (this._options.getReadPreference() != null) {
            this.setReadPreference(this._options.getReadPreference());
        }
        this.setWriteConcern(this._options.getWriteConcern());
    }

    @Deprecated
    public MongoOptions getMongoOptions() {
        return this._options;
    }

    public int getMaxBsonObjectSize() {
        return this._connector.getMaxBsonObjectSize();
    }

    boolean isMongosConnection() {
        return this._connector.isMongosConnection();
    }

    private static MongoAuthority getMongoAuthorityFromURI(MongoURI uri) throws UnknownHostException {
        if (uri.getHosts().size() == 1) {
            return MongoAuthority.direct(new ServerAddress(uri.getHosts().get(0)), uri.getCredentials());
        }
        ArrayList<ServerAddress> replicaSetSeeds = new ArrayList<ServerAddress>(uri.getHosts().size());
        for (String host : uri.getHosts()) {
            replicaSetSeeds.add(new ServerAddress(host));
        }
        return MongoAuthority.dynamicSet(replicaSetSeeds, uri.getCredentials());
    }

    public CommandResult fsync(boolean async) {
        BasicDBObject cmd = new BasicDBObject("fsync", (Object)1);
        if (async) {
            cmd.put("async", (Object)1);
        }
        return this.getDB(ADMIN_DATABASE_NAME).command(cmd);
    }

    public CommandResult fsyncAndLock() {
        BasicDBObject cmd = new BasicDBObject("fsync", (Object)1);
        cmd.put("lock", (Object)1);
        return this.getDB(ADMIN_DATABASE_NAME).command(cmd);
    }

    public DBObject unlock() {
        DB db = this.getDB(ADMIN_DATABASE_NAME);
        DBCollection col = db.getCollection("$cmd.sys.unlock");
        return col.findOne();
    }

    public boolean isLocked() {
        DB db = this.getDB(ADMIN_DATABASE_NAME);
        DBCollection col = db.getCollection("$cmd.sys.inprog");
        BasicDBObject res = (BasicDBObject)col.findOne();
        if (res.containsField("fsyncLock")) {
            return res.getInt("fsyncLock") == 1;
        }
        return false;
    }

    public String toString() {
        return "Mongo{authority=" + this._authority + ", options=" + this._options + '}';
    }

    MongoAuthority getAuthority() {
        return this._authority;
    }

    class CursorCleanerThread
    extends Thread {
        CursorCleanerThread() {
            this.setDaemon(true);
            this.setName("MongoCleaner" + this.hashCode());
        }

        public void run() {
            while (Mongo.this._connector.isOpen()) {
                try {
                    try {
                        Thread.sleep(cleanerIntervalMS);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    for (DB db : Mongo.this._dbs.values()) {
                        db.cleanCursors(true);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
    }

    public static class Holder {
        private static Holder _default = new Holder();
        private final ConcurrentMap<String, Mongo> _mongos = new ConcurrentHashMap<String, Mongo>();

        @Deprecated
        public Mongo connect(MongoURI uri) throws UnknownHostException {
            return this.connect(uri.toClientURI());
        }

        public Mongo connect(MongoClientURI uri) throws UnknownHostException {
            String key = this.toKey(uri);
            Mongo client = (Mongo)this._mongos.get(key);
            if (client == null) {
                MongoClient newbie = new MongoClient(uri);
                client = this._mongos.putIfAbsent(key, newbie);
                if (client == null) {
                    client = newbie;
                } else {
                    newbie.close();
                }
            }
            return client;
        }

        private String toKey(MongoClientURI uri) {
            return uri.toString();
        }

        public static Holder singleton() {
            return _default;
        }
    }
}

